#ifndef    __AMPED_RF_WLAN_DRIVER_H_
#define    __AMPED_RF_WLAN_DRIVER_H_
#include "FreeRTOS.h"
#include "queue.h"
#define WLAN_SPI_Direction_2Lines_FullDuplex ((u16_t)0x0000)
#define WLAN_SPI_Direction_2Lines_RxOnly     ((u16_t)0x0400)
#define WLAN_SPI_Direction_1Line_Rx          ((u16_t)0x8000)
#define WLAN_SPI_Direction_1Line_Tx          ((u16_t)0xC000)

#define WLAN_SPI_DataSize_16b                ((u16_t)0x0800)
#define WLAN_SPI_DataSize_8b                 ((u16_t)0x0000)

#define WLAN_SPI_CPOL_Low                    ((u16_t)0x0000)
#define WLAN_SPI_CPOL_High                   ((u16_t)0x0002)

#define WLAN_SPI_CPHA_1Edge                  ((u16_t)0x0000)
#define WLAN_SPI_CPHA_2Edge                  ((u16_t)0x0001)

#define WLAN_SPI_BaudRatePrescaler_2         ((uint16_t)0x0000)
#define WLAN_SPI_BaudRatePrescaler_4         ((uint16_t)0x0008)
#define WLAN_SPI_BaudRatePrescaler_8         ((uint16_t)0x0010)
#define WLAN_SPI_BaudRatePrescaler_16        ((uint16_t)0x0018)
#define WLAN_SPI_BaudRatePrescaler_32        ((uint16_t)0x0020)
#define WLAN_SPI_BaudRatePrescaler_64        ((uint16_t)0x0028)
#define WLAN_SPI_BaudRatePrescaler_128       ((uint16_t)0x0030)
#define WLAN_SPI_BaudRatePrescaler_256       ((uint16_t)0x0038)

#define WLAN_SPI_MASTER_ROLE                 ((u8_t)0x0001)
#define WLAN_SPI_SLAVE_ROLE                  ((u8_t)0x0000)

typedef struct
{
    unsigned short DataSize;              //16bit or 8bit one time,default value is 16bit
    unsigned short Cpol;                  // low or high,default value is low
    unsigned short Cpha;                  // 1Edge or 2Edge, default value is 1Edge
    unsigned short BaudratePrescaler;     //the default cpu is 84M, use baudrateprescaler to prescaler from cpu clock
                                          //if set as SPI_BaudRatePrescaler_2, the spi clock is 84M/2=42M
                                          //default value is SPI_BaudRatePrescaler_8
    unsigned short DmaSize;               // a fixed size, after DMA have this size of data, DMA complete interrupt generate
                                          //default value is 1000byte
    unsigned char Enabled;                // enable or disable spi function, default value is disable
    unsigned char Role;                   // master mode=1, slave mode=0, default value is slave mode
    unsigned char MasterRcvInterruptUsed; // when slave high the request pin to notify master there is data coming,
                                          // whether master use an interrupt to know there is data coming
                                          // default value is true; user also can detect the pin change themself
}tSPIDevice;

typedef struct
{
    unsigned char      MsgType;
    unsigned short     DataLen;
    unsigned char     *pData;
} SpiMsg;


//gpio index
typedef enum gpio_e
{
    WLAN_GPIO_0,
    WLAN_GPIO_1,
    WLAN_GPIO_2,
    WLAN_GPIO_3,
    WLAN_GPIO_4,
    WLAN_GPIO_5,
    WLAN_GPIO_6,
    WLAN_GPIO_7,
    WLAN_GPIO_8,
    WLAN_GPIO_9,
    WLAN_GPIO_10,
    WLAN_GPIO_11,
}wlan_gpio_t;

//gpio direction
typedef enum gpio_direction_e
{
    GPIO_INPUT,
    GPIO_OUTPUT
}gpio_direction_t;

typedef enum uart_port_e
{
    UART_PORT0,
    UART_PORT1,
    UART_PORT2
}uart_port_t;

typedef enum spi_port_e
{
    SPI_PORT0,
    SPI_PORT1,
    SPI_PORT2
}spi_port_t;


//uart callback function prototype
typedef void (* uart_callback)(unsigned char *pBuf, unsigned short len);
//timer callback function prototype
typedef void (* timer_callback)( TimerHandle_t xTimer ); //(void);
extern xQueueHandle xSpiQueue;

extern void vUartTask( void *pvParameters );

#define vATCmdTask vUartTask

extern void wlan_uart_init(uart_port_t PortNum,u32_t BaudRate,u8_t DataLen,u8_t StopBit,u8_t Parity,bool FlowCtrl);//initialize the uart
extern API_ROOT void wlan_uart_send(uart_port_t PortNum, u8_t data);                              //uart send data function
extern u8_t wlan_uart_rcv(uart_port_t PortNum);                                            //uart receive data function
extern u16_t wlan_spi_send(spi_port_t PortNum, u16_t data);
extern u16_t wlan_spi_rcv(spi_port_t portnum);

#if 1
extern API_ROOT void wlan_spi_init(spi_port_t portnum);                                                    //spi init
extern API_ROOT void wlan_spi_snd_bytes(unsigned char* sndbuf, unsigned short len);                            //spi send data function
extern API_ROOT void wlan_spi_sndrcv_bytes(unsigned char* sndbuf, unsigned char* rcvbuf, unsigned short len);  //master mode,spi receive data function
extern API_ROOT void wlan_spi_rcv_bytes(unsigned char *rcvbuf, unsigned short len);                            //slave mode, spi receive data function
#endif
extern API_ROOT void wlan_gpio_config(wlan_gpio_t gpio, gpio_direction_t dir);                                 //config the gpio
extern API_ROOT void wlan_gpio_set(wlan_gpio_t gpio, unsigned char value);                                     //set the gpio status
extern API_ROOT unsigned char wlan_gpio_get(wlan_gpio_t gpio);                                                 //get the gpio status
extern API_ROOT unsigned char wlan_timer_config(const char * const pTimerName, unsigned   long TimerPeriodInTicks,
                                       unsigned long uxAutoReload, void * const pvTimerID, timer_callback pxCallbackFunction);
                                                                                                      //timer config function
extern API_ROOT void wlan_timer_destroy(unsigned char index);
extern API_ROOT void wlan_timer_start(unsigned char index);                                                    //lauch the timer
extern API_ROOT void wlan_timer_stop(unsigned char index);                                                     //stop the timer


#endif /* __PING_H__ */
