#ifndef    __AMPED_RF_WLAN_CONFIG_H_
#define    __AMPED_RF_WLAN_CONFIG_H_


//==============================================================================


#ifdef __cplusplus
extern "C" {    //////////////////////////////////////////////////////////////////
#endif

//ip address struct
struct ip_address{
    u32_t addr;
};


extern u32_t htonl(u32_t x);

#define IP4_ADDR(ipaddr, a,b,c,d) \
        (ipaddr)->addr = htonl(((u32_t)((a) & 0xff) << 24) | \
                               ((u32_t)((b) & 0xff) << 16) | \
                               ((u32_t)((c) & 0xff) << 8) | \
                                (u32_t)((d) & 0xff))

//integer format IP
typedef struct ip_info_int_s{
    struct ip_address ip;      /**< IP address */
    struct ip_address netmask; /**< netmask */
    struct ip_address gateway; /**< gateway */
}ip_info_int_t;

//string format IP
typedef struct ip_info_str_s{
    char ip[16];          /**< IP address */
    char netmask[16];    /**< netmask */
    char gateway[16];    /**< gateway */
}ip_info_str_t;

//sleep mode
typedef enum sleep_mode_e{
    NO_SLEEP,
    SHALLOW_SLEEP,
    DEEP_SLEEP,
    SHALLOW_DEEP_SLEEP
}sleep_mode_t;

//operate mode
typedef enum operate_mode_e{
    STA=0,
    AP,
    AP_STA,
    MP,
    AP_MP
}operate_mode_t;


extern API_ROOT char* wlan_get_device_name(void);                          //get the device name
extern API_ROOT u8_t wlan_set_device_name(char* pName);                    //set the device name
extern API_ROOT void wlan_get_mac_address(u8_t* pMac);                     //get the mac address
extern API_ROOT void wlan_set_mac_address(u8_t* pMac);                     //set the mac address
extern API_ROOT bool wlan_get_dhcp_mode(void);                             //get the dhcp mode
extern API_ROOT u8_t wlan_set_dhcp_mode(bool mode);                        //set the dhcp mode
extern API_ROOT void wlan_get_ip_info(ip_info_int_t* pIP_int);             //get the ip info
extern API_ROOT u8_t wlan_set_ip_info(ip_info_str_t ip_str);               //set the ip
extern API_ROOT sleep_mode_t wlan_get_sleep_mode(void);                    //get the sleep mode
extern API_ROOT u8_t wlan_set_sleep_mode(sleep_mode_t mode);               //set the sleep mode
extern API_ROOT u8_t wlan_set_operation_mode(operate_mode_t mode);         // set the wifi work mode
extern API_ROOT operate_mode_t wlan_get_operation_mode(void);
extern API_ROOT void wlan_get_config_byID(char* buf, u16_t len, u16_t id);  //get config info by id

/* --- System Configuration Variable IDs (AMP_VARID) --- */
#define AMP_VARID_BUILD_VERSION           1
#define AMP_VARID_DEVICE_NAME             2
#define AMP_VARID_STA_MAC_ADDR            3
#define AMP_VARID_DHCP_MODE               4
#define AMP_VARID_IP_ADDRESS              5
#define AMP_VARID_NET_MASK                6
#define AMP_VARID_GATE_WAY                7
#define AMP_VARID_SSID                    8
#define AMP_VARID_PASS_PHRASE             9
#define AMP_VARID_AUTH_TYPE               10
#define AMP_VARID_HOST_IP_ADDR            11
#define AMP_VARID_IP_PROTOCOL             12
#define AMP_VARID_HOST_PORT               13
#define AMP_VARID_LOCAL_PORT              14
#define AMP_VARID_UART_BAUDRATE           15
#define AMP_VARID_UART_PARITY             16
#define AMP_VARID_UART_DATA_BITS          17
#define AMP_VARID_UART_STOP_BITS          18
#define AMP_VARID_UART_FLOW_CONTROL       19
#define AMP_VARID_UART_TIMEOUT            20
#define AMP_VARID_HOST_EVENTS             22
#define AMP_VARID_HARDWARE                25
#define AMP_VARID_CPU_MHZ                 26
#define AMP_VARID_CHANNEL                 27
#define AMP_VARID_DEVICE_MODE             28
#define AMP_VARID_OUT_MTU_SIZE            29
#define AMP_VARID_MAX_STA_COUNT           30
#define AMP_VARID_MP_MODE                 31
#define AMP_VARID_HOST_SHALLOW_SLEEP_EN   33
#define AMP_VARID_HOST_DEEP_SLEEP_EN      34
#define AMP_VARID_WIFI_SLEEP_TIME         35
#define AMP_VARID_KEEP_ALIVE              36
#define AMP_VARID_STATION_INACTIVE        38
#define AMP_VARID_WSM_FIRMWARE            39
#define AMP_VARID_WSM_BOOTLOADER          40
#define AMP_VARID_WSM_SDD                 41
#define AMP_VARID_MQTT_SERVER_IP          42
#define AMP_VARID_MQTT_SERVER_PORT        43
#define AMP_VARID_MQTT_SERVER_USR_NAME    44
#define AMP_VARID_MQTT_SERVER_PASSWD      45
#define AMP_VARID_MQTT_SUBSCRIBE_TOPIC    46
#define AMP_VARID_MQTT_PUBISH_TOPIC       47
#define AMP_VARID_MQTT_QOS                48
#define AMP_VARID_MQTT_AUTH_TYPE          49
#define AMP_VARID_LOCAL_IPV6_ADDRS        50
#define AMP_VARID_REMOTE_IPV6_ADDRS       51
#define AMP_VARID_ADDR_TYPE               52
#define AMP_VARID_LINK_TYPE               53
#define AMP_VARID_MQTT_CA_CRT             54
#define AMP_VARID_MQTT_CLIENT_CRT         55
#define AMP_VARID_MQTT_CLIENT_KEY         56
#define AMP_VARID_DNS1V4                  57
#define AMP_VARID_DNS1V6                  58
#define AMP_VARID_DNS2V4                  59
#define AMP_VARID_DNS2V6                  60
#define AMP_VARID_MESH_ID                 61
#define AMP_VARID_MESH_PASS_PHRASE        62
#define AMP_VARID_MESH_AUTH_TYPE          63
#define AMP_VARID_APP_AUTO_START          64
#define AMP_VARID_AUTO_SSID               65
#define AMP_VARID_PASS_PHRASE_ALT         66
/*******************************************************************************
* Function Name  : wlan_config_info
* Description    : set the config info, or print the config info to uart
*                  if var_id =0, pconfig_info=0,it will print all config info to uart,wlan_config_info(0,0);
*                  if var_id=(1,46),pconfig_info=0, it will print var_id config info to uart,wlan_config_info(28,0);
*                  if var_id=(1,46),pconfig_info!=0, it will set the pconfig_info to var_id,wlan_config_info(28, "AP");
                   below is all the var_id and default value,var38-var47 is reserved for customized                   
                   var01 BuildVersion             = 180116A
                   var02 DeviceName               = Amped WiFi
                   var03 MAC_ADDR                 = 00043e212345
                   var04 DHCPMode                 = true
                   var05 IPAddress                = 192.168.0.2
                   var06 NetMask                  = 255.255.255.0
                   var07 GateWay                  = 192.168.0.1
                   var08 SSID                     = Amped AP
                   var09 PassPhrase               = 12345678
                   var10 AuthType                 = 1
                   var11 HostIPAddr               = 192.168.0.10
                   var12 IPProtocol               = UDP
                   var13 HostPort                 = 2015
                   var14 LocalPort                = 2015
                   var15 UartBaudrate             = 115200
                   var16 UartParity               = none
                   var17 UartDataBits             = 8
                   var18 UartStopBits             = 1
                   var19 UartFlowControl          = false
                   var20 UartTimeout              = 16
                   var22 HostEvents               = true
                   var25 Hardware                 = WF63
                   var26 CpuMHz                   = 84
                   var27 Channel                  = 1
                   var28 DeviceMode               = STA
                   var29 OutMtuSize               = 1000
                   var30 MaxSTACount              = 5
                   var31 MPMode                   = 0
                   var33 HostShallowSleepEn       = false
                   var34 HostDeepSleepEn          = false
                   var35 StationInactive          = 120
                   var36 SPIEnable                = false
                   var37 SPIMode                  = slave
                   var38 Reserve1                 = Reserve
                   var39 Reserve2                 = Reserve
                   var40 Reserve3                 = Reserve
                   var41 Reserve4                 = Reserve
                   var42 Reserve5                 = Reserve
                   var43 Reserve6                 = Reserve
                   var44 Reserve7                 = Reserve
                   var45 Reserve8                 = Reserve
                   var46 Reserve9                 = Reserve
                   var47 Reserve10                = Reserve
*******************************************************************************/
extern API_ROOT void wlan_config_info(unsigned char var_id, char* pconfig_info);


#ifdef __cplusplus
}    //////////////////////////////////////////////////////////////////////////////
#endif

#endif
//==============================================================================
