
#ifndef    __AMPED_RF_WLAN_COM_H_
#define    __AMPED_RF_WLAN_COM_H_


#ifdef __cplusplus
extern "C" {    //////////////////////////////////////////////////////////////////
#endif

#define WLAN_RX_BUFFER_SIZE    3000
#define WLAN_SCAN_ITEM_MAX    10

//connect type
enum wlan_connect_type {
    WLANCONN_INVALID,
    WLANCONN_UDP,
    WLANCONN_TCP_CLIENT,
    WLANCONN_TCP_SERVER
};

//auth type
enum wlan_auth_type{
    NONE,
    WPA2
};

//event type
enum wlan_event_type {
    WLAN_EVENT_NONE,
    WLAN_EVENT_RX,
    WLAN_EVENT_TX
};

//scan status
enum wlan_scan_status_type{
    NOSCAN,
    SCANNING,
    SCANDONE
};

//scan data struct
typedef struct scan_data_s{
    int signal;
    int freq;
    u8_t bssid[6];
    char ssid[32];
    void *next;
} scan_data_t;

//scan callback fuction prototype
typedef void (*scan_callback_t)(const scan_data_t *pScandata);

//scan list struct
typedef struct scan_list_s{
    scan_data_t *head;
    scan_data_t *tail;
    void *mem;
    u16_t item_total;
    u16_t item_count;
    scan_callback_t scan_cb;
    u8_t status;
} scan_list_t;

//router config struct
/*******************************************************************************
* struct Name  : router config struct
* Description  : about the ssid and password, there are three type to use
*                1. set both ssid and password :it means we should use the new ssid and password
*                2. set just ssid              :it means the router don't have an encryption
*                3. don't set ssid and password:it means we will use default ssid and password
*******************************************************************************/
typedef struct wlan_ap_s{
    char ssid[32];
    char password[64];
}wlan_ap_t;

//station info
struct station_info_s {
    u32_t ipAddr;
    u16_t portid;
};

//wlan callback function prototype
typedef void (* wlan_callback)(u8_t *pBuf, u16_t len);

//station struct
typedef struct wlan_station_s {
    struct station_info_s local;
    struct station_info_s remote;
    wlan_callback rx;
}wlan_station_t;

//==============================================================================
// I.    Application Functions
//==============================================================================
#ifdef WORK_MODE_STA
extern API_ROOT u8_t wlan_sta_scan (scan_callback_t *scan_done_cb);         //wlan scan function
extern API_ROOT void wlan_show_scan_result (void);         //wlan scan function
extern API_ROOT u8_t wlan_sta_join(wlan_ap_t *pAP);                         //join to the router
extern API_ROOT void wlan_sta_unjoin(void);                                 //unjoin from the router
#endif
extern API_ROOT u8_t wlan_sta_connect(u8_t protocol, wlan_station_t *pSta); //connect to a appointed router
extern API_ROOT void wlan_sta_disconnect(u32_t ipaddr, u8_t protocol); //disconnect with the router
extern u8_t wlan_sta_send(u32_t ipaddr, u8_t *pBuf, u16_t len);// send the appointed data
extern API_ROOT bool wlan_sta_status(void);                                 // get wlan conn status
extern API_ROOT void wlan_ap_showNetwork(void);                             // show the station list
extern API_ROOT u8_t wlan_mqtt_get_status(void);
extern API_ROOT u8_t wlan_mesh_get_status(void);

#ifdef __cplusplus
}    //////////////////////////////////////////////////////////////////////////////
#endif

#endif
