/***************************************************************************************************
 *                              MCU ACH118X driver library
 *                      COPYRIGHT(c) 2020 Amped RF Technology (ART)
 *                                 All Rights Reserved
 *
 * @file     AT_AppVar.h
 * @brief    App runtime information.
 * @version  V1.0.0
 * @date     05-Nov-2020
 ***************************************************************************************************/
#ifndef __AT_APPVAR_H
#define __AT_APPVAR_H

#define AT_MAX_ESCAPE_SEQ_LENGTH        6
#define AT_DEFAULT_ESCAPE_SEQ_LENGTH    6
#define AT_DEFAULT_ESCAPE_SEQ           "^#^$^%"
#define AT_MAX_TEMP_BUFF_LENGTH         60

typedef struct tAT_AppVar{
  bool              HostEvents;
  bool              CheckCommandID;  // true for checking Command ID
  bool              fLastCmdCharCRLF;// whether last cmd char processed was CR/LF
  uint8_t           MainState;
  uint16_t          BufIndx;         // Command Buffer Index
  bool              Connected;       // Indicates module connection status udp/tcp
  bool              Joined;          // Indicates module join a network
  bool              SocketOpen;
  char              TmpBuf[AT_MAX_TEMP_BUFF_LENGTH+1]; // Temp data storage + null
  char              EscapeSeq[AT_MAX_ESCAPE_SEQ_LENGTH+1];
  uint8_t           EscapeSeqLength;
  uint8_t           Protocol;
  uint8_t           MPmode;
  uint8_t           acAp[32];
  uint8_t           sacPsk[64];
  bool              SleepEnable;//michael_lowpower
}tAT_AppVar;

#endif // __AT_APPVAR_H

