//------------------------------------------------------------------------------
//
// File: ymodem.h
//
// (C) Copyright 2017 Amped RF Technology
//------------------------------------------------------------------------------
#ifndef _YMODEM_H_
#define _YMODEM_H_

#include <stdio.h>
#include <yvals.h>
#include "GKI_uart.h"

typedef void(*vfunc_u8)(uint8_t data);
typedef u8(*u8func_v)(void);

typedef struct{
	u8 status; 
	vfunc_u8 putChar;
	u8func_v getChar;
	u8func_v isDataReady;
}t_Ymodem;

uint8_t Ymodem_ReceiveInterface(uint8_t *pBuf, vfunc_u8 pfPutCh, u8func_v pfGetCh, u8func_v pfDataReady); 

#define PACKET_HEADER           (3)
#define PACKET_TRAILER          (2)
#define PACKET_OVERHEAD         (PACKET_HEADER + PACKET_TRAILER)
#define PACKET_SIZE             (128)
#define PACKET_1K_SIZE          (1024)

#define YMODEM_SOH				(0x01)  /* start of 128-byte data packet */
#define YMODEM_STX              (0x02)  /* start of 1024-byte data packet */
#define YMODEM_EOT				(0x04)  /* end of transmission */
#define YMODEM_ACK				(0x06)  /* acknowledge */
#define YMODEM_NAK				(0x15)  /* negative acknowledge */
#define YMODEM_CAN				(0x18)  /* two of these in succession aborts transfer */
#define YMODEM_C				(0x43)  /* 'C' == 0x43, request 16-bit CRC */
#define YMODEM_ABORT1           (0x41)  /* 'A' == 0x41, abort by user */
#define YMODEM_ABORT2           (0x61)  /* 'a' == 0x61, abort by user */

#define YM_DATA              	(0)
#define YM_FILENAME             (1)
#define YM_END             		(2)
#define YM_CANCEL           	(3)
#define YM_FINISH           	(4)
#define YM_ERROR          		(5)
#define YM_ILLEGAL          	(6)

#define STATUS_WaitFileName		(0)
#define STATUS_RequestData		(1)
#define STATUS_ReceiveFileData	(2)
#define STATUS_FileFinishCheck	(3)

#endif  // _YMODEM_H_

/*******************(C) Copyright 2017 Amped RF Technology *****END OF FILE****/
