/*********************************************************************************************************
*                                        CODEC WM8904 driver
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: wm8904_conf.h
* Version	: V1.0.0
* Brief:    : This file contains all the porting interface for the WM8904 driver.  
* ---------------
**********************************************************************************************************/
#ifndef _WM8904_CONF_H
#define _WM8904_CONF_H
    
#include <stdint.h>
#include "ach118x_type.h"
#include "GKI_wm8904.h"
    
#ifdef __cplusplus
        extern "C" {
#endif

//Device ID
#define WM8904_DEV_ID                   (0x8904)
//Chip I2C slave address.
#define WM8904_CHIPADDR                 (0x34)

//------------------------------------------------------------------
// Porting interface.
// This interface should achieve I2C writing communication.
//-------------------
// Details are shown below:
// 1.Parameters:
//   @WM8904_CHIPADDR:
//             This is slave device address. The target is WM8904, so
//             the address is confirmed. It is defined above.
//   @addr:    This is the target register address. The data will be
//             write to this start address.
//   @data:    This is a buffer which contains the data to be write.
//   @payload: The data length.
// 2.The function:
//       This interface should contain the STA and STO signal
//   generation. The standard I2C writing sequence is
//       STA + DevAddr + RegAddr + Data... + STO.
//   This interface should achieve the sequence above.
// 3.Device address:
//       The device address should not shift bit to left or right.
//   For example, the WM8904 device address is 0x34, the I2C should
//   send it as (0 0 1 1 0 1 0 0) by binary.
//------------------------------------------------------------------
#define wm8904_I2cWrData(addr, data, payload)       GKI_I2cTxData(WM8904_CHIPADDR, addr, data, payload)
//------------------------------------------------------------------
// Porting interface.
// This interface should achieve I2C reading communication.
//-------------------
// Details are shown below:
// 1.Parameters:
//   @WM8904_CHIPADDR:
//             This is slave device address. The target is WM8904, so
//             the address is confirmed. It is defined above.
//   @addr:    This is the target register address. The data will be
//             write to this start address.
//   @data:    This is a buffer which contains the data to be write.
//   @payload: The data length.
// 2.The function:
//       This interface should contain the STAReSTA and STO signal
//   generation. The standard I2C reading sequence is
//       STA + DevAddr + RegAddr + ReSTA + DevAddr + Data... + STO.
//   This interface should achieve the sequence above.
// 3.Device address:
//       The device address should not shift bit to left or right.
//   For example, the WM8904 device address is 0x34, the I2C should
//   send it as (0 0 1 1 0 1 0 0) by binary when writing register
//   address and send it as (0 0 1 1 0 1 0 1) by binary when reading
//   data.
//------------------------------------------------------------------
#define wm8904_I2cRdData(addr, data, payload)       GKI_I2cRxData(WM8904_CHIPADDR, addr, data, payload)

#ifdef __cplusplus
		}//extern "C" 
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
