//------------------------------------------------------------------------------
//
// tiny_fs.h
//
// Writer:	Frank
// Created: 10/18/2017
// To support SPI flash file system, so application can parse this file system. 
// 
// (C) Copyright 2017 Amped RF Technology
//------------------------------------------------------------------------------
#ifndef __TINY_FS_H
#define __TINY_FS_H

#include <stdint.h>

#define FILE_ENTRY_SIZE				    (64)
#define FILE_ENTRY_NUM				    (64)

#define FILE_DIRECTORY_START_ADDRESS 	(0x2000)
#define FILE_DIRECTORY_SIZE			    (0x1000)

#define CONFIG_REGION_START_ADDRESS     (0x3000)
#define CONFIG_REGION_SIZE			    (0x2000)

typedef enum{
	Type_Invalid = 0x00,
	Type_Valid = 0x0F,
	Type_End = 0xFF	
}tEntryType;

typedef struct FILE_INFO_T {
uint8_t		entry_type;
uint8_t		attribute;
uint16_t	start_sector;
uint32_t	size;
uint8_t		name[32]; 
} file_info_t;

typedef struct FILE_INFO_EXT_T {
uint8_t		entry_type;
uint8_t		attribute;
uint16_t	start_sector;
uint32_t	size;
uint8_t		name[32]; 
uint32_t	address;
uint8_t		isExistent;
} file_info_ext_t;

typedef struct FILE_ENTRY_T {
file_info_t info;
uint8_t	reserved[24];
} file_entry_t;

typedef union FILE_COMMON_INFO_T{
	file_info_t info;
	file_info_ext_t usr_info;
}file_common_info_t;

typedef void (*pfFlashRead)(uint32_t addr, uint8_t *pBuf, uint32_t len);

typedef struct FILE_SYS_T {
uint8_t count;
file_info_t *pInfoList[FILE_ENTRY_NUM];
pfFlashRead flash_read;
} file_sys_t;

extern file_sys_t FS;
extern file_common_info_t bootloader;
extern file_common_info_t wsm;
extern file_common_info_t sdd;

void FM_showFileInfo(void);
void FS_Init(void);

#endif //__FS_H
/************************ (C) COPYRIGHT ART *****END OF FILE****/
