/*********************************************************************************************************
*                                     Authentication Coprocessor
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: coprocessor_cfg.h
* Version	: V1.0.0
* Brief:    : This file contains all the porting interface for coprocessor.  
* ---------------
* NOTE: CP is a chip, iPod Authentication Coprocessor.
**********************************************************************************************************/
#ifndef _COPROCESSOR_CFG_H
#define _COPROCESSOR_CFG_H
    
#include <stdint.h>
#include "ach118x_type.h"
#include "GKI_wm8904.h"//This GKI include the I2C driver.
#include "GKI_cp.h"
    
#ifdef __cplusplus
        extern "C" {
#endif

//This is the RST pin status of the CP.
#define RST_PIN_STATUS      (SET)
//This is the CP device address.
#define CP_DEV_ADDR         (0x20 | (RST_PIN_STATUS << 1))

//------------------------------------------------------------------
// Porting interface.
// This interface should achieve I2C writing communication.
//-------------------
// Details are shown below:
// 1.Parameters:
//   @CP_DEV_ADDR:
//             This is slave device address. The target is CP, so
//             the address is confirmed. It is defined above.
//   @addr:    This is the target register address. The data will be
//             write to this start address.
//   @data:    This is a buffer which contains the data to be write.
//   @payload: The data length.
// 2.The function:
//       This interface should contain the STA and STO signal
//   generation. The standard I2C writing sequence is
//       STA + DevAddr + RegAddr + Data... + STO.
//   But only achieving this sequence is not enough. The CP will return 
//   a NAK to respond the device address when it is not ready. 
//   I2C should keep sending the STA signal and device address until
//   CP return an ACK.
// 3.Device address:
//       The device address should not shift bit to left or right.
//   For example, the CP device address is 0x22, the I2C should
//   send it as (0 0 1 0 0 0 1 0) by binary.
//------------------------------------------------------------------
#define appleCp_I2cWrData(addr, data, payload)       GKI_I2cKeepTxData(CP_DEV_ADDR, addr, data, payload)
//------------------------------------------------------------------
// Porting interface.
// This interface should achieve I2C reading communication.
//-------------------
// Details are shown below:
// 1.Parameters:
//   @CP_DEV_ADDR:
//             This is slave device address. The target is CP, so
//             the address is confirmed. It is defined above.
//   @addr:    This is the target register address. The data will be
//             write to this start address.
//   @data:    This is a buffer which contains the data to be write.
//   @payload: The data length.
// 2.The function:
//       This interface should contain the STAReSTA and STO signal
//   generation. The standard I2C reading sequence is
//       STA + DevAddr + RegAddr + ReSTA + DevAddr + Data... + STO.
//   But only achieving this sequence is not enough. The CP will return 
//   a NAK to respond the device address when it is not ready. 
//   I2C should keep sending the STA signal and device address until
//   CP return an ACK.
// 3.Device address:
//       The device address should not shift bit to left or right.
//   For example, the CP device address is 0x22, the I2C should
//   send it as (0 0 1 0 0 0 1 0) by binary when writing register
//   address and send it as (0 0 1 0 0 0 1 1) by binary when reading
//   data.
//------------------------------------------------------------------
#define appleCp_I2cRdData(addr, data, payload)       GKI_I2cKeepRxData(CP_DEV_ADDR, addr, data, payload)


#ifdef __cplusplus
		}//extern "C" 
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
