/*********************************************************************************************************
*                                        Authentication Coprocessor
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: coprocessor.h
* Version	: V1.0.0
* Brief:    : This file contains all the functions prototypes for coprocessor.  
* ---------------
* NOTE: CP is a chip, iPod Authentication Coprocessor.
**********************************************************************************************************/
#ifndef _COPROCESSOR_H
#define _COPROCESSOR_H

#include <stdint.h>
#include "coprocessor_cfg.h"

#ifdef __cplusplus
    extern "C" {
#endif

//------------------------------------------------------------------
// Device version register.
// Reading from this register will get the version 0x05.
//------------------------------------------------------------------
#define MFI_DEV_VERSION_REG                      (0x00)

//------------------------------------------------------------------
// Firmware version register.
// Reading from this register will get the version 0x01.
//------------------------------------------------------------------
#define MFI_FW_VERSION_REG                       (0x01)

//------------------------------------------------------------------
// Authentication protocol major version register.
// Reading from this register will get the version 0x02.
//------------------------------------------------------------------
#define MFI_AUTH_PROTOCOL_MAJOR_VERSION_REG      (0x02)

//------------------------------------------------------------------
// Authentication protocol minor version register.
// Reading from this register will get the version 0x00.
//------------------------------------------------------------------
#define MFI_AUTH_PROTOCOL_MINOR_VERSION_REG      (0x03)

//------------------------------------------------------------------
// Device ID register.
// Reading from this register will get the ID 0x00000200.
//------------------------------------------------------------------
#define MFI_DEV_ID_REG                           (0x04)

//------------------------------------------------------------------
// Error code register.
// Reading from this register will get the error code.
// This register will be cleared on reading.
//------------------------------------------------------------------
#define MFI_ERR_CODE_REG                         (0x05)

//------------------------------------------------------------------
// Authentication control and status register.
//------------------------------------------------------------------
#define MFI_AUTHCTRL_STATUS_REG                  (0x10)
//Read-only PROC_RESULT options.
typedef enum {
    CP_PROCESS_INVALID = 0,
    CP_SIGNATURE_GENER_SUC = 1,
    CP_CHALLENGE_GENER_SUC = 2,
    CP_SIGNATURE_VERIFY_SUC = 3,
    CP_CERTI_VALID_SUC = 4
} cpAuthRdProcResult_t;
//write-only PROC_RESULT options.
typedef enum {
    CP_NO_OPERATION0 = 0,
    CP_NEW_SIGNATURE_GENER = 1,
    CP_NEW_CHALLENGE_GENER = 2,
    CP_NEW_SIGNATURE_VERIFY = 3,
    CP_NEW_CERTI_VALID = 4,
    CP_NO_OPERATION5 = 5
} cpAuthWrProcResult_t;
//Authentication control and status register structure type definition.
typedef union _cpAuthCtrlStatusReg_t{
    uint8_t regVal;
    struct {
        uint8_t WR_PROC_RESULTS : 3;
        uint8_t reserved        : 1;
        uint8_t RD_PROC_RESULTS : 3;
        uint8_t ERR_SET         : 1;
    } bits;
} cpAuthCtrlStatusReg_t;

//------------------------------------------------------------------
// Signature data length register.
//------------------------------------------------------------------
#define MFI_SIGNATURE_DATA_LEN_REG               (0x11)

//------------------------------------------------------------------
// Signature data register.
//------------------------------------------------------------------
#define MFI_SIGNATURE_DATA_REG                   (0x12)

//------------------------------------------------------------------
// Challenge data length register.
//------------------------------------------------------------------
#define MFI_CHALLENGE_DATA_LEN_REG               (0x20)

//------------------------------------------------------------------
// Challenge data register.
//------------------------------------------------------------------
#define MFI_CHALLENGE_DATA_REG                   (0x21)

//------------------------------------------------------------------
// Accessory certificate data length register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_LEN_REG               (0x30)

//------------------------------------------------------------------
// Accessory certificate data page1 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE1_REG             (0x31)

//------------------------------------------------------------------
// Accessory certificate data page2 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE2_REG             (0x32)

//------------------------------------------------------------------
// Accessory certificate data page3 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE3_REG             (0x33)

//------------------------------------------------------------------
// Accessory certificate data page4 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE4_REG             (0x34)

//------------------------------------------------------------------
// Accessory certificate data page5 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE5_REG             (0x35)

//------------------------------------------------------------------
// Accessory certificate data page6 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE6_REG             (0x36)

//------------------------------------------------------------------
// Accessory certificate data page7 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE7_REG             (0x37)

//------------------------------------------------------------------
// Accessory certificate data page8 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE8_REG             (0x38)

//------------------------------------------------------------------
// Accessory certificate data page9 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE9_REG             (0x39)

//------------------------------------------------------------------
// Accessory certificate data page10 register.
//------------------------------------------------------------------
#define MFI_ACC_CERTI_DATA_PAGE10_REG            (0x3A)

//------------------------------------------------------------------
// Self-test control and status register.
//------------------------------------------------------------------
#define MFI_SELFTESTCTRL_STATUS_REG              (0x40)
//Self-test control options.
typedef enum {
    CP_NONE = 0,
    CP_RUN_X509_TEST = 1
} cpSelfTestProcCtrl_t;
//Selt-test result options.
typedef enum {
    CP_NOT_FOUND = 0,
    CP_FOUND = 1
} cpSelfTestResult_t;
//Self-test control and status register structure type definition.
typedef union _cpSelfTestCtrlStatusReg_t{
    uint8_t regVal;
    struct {
        uint8_t WR_PROC_CTRL : 3;
        uint8_t reserved     : 3;
        uint8_t Key_RESULT   : 1;
        uint8_t CERTI_RESULT : 1;
    } bits;
} cpSelfTestCtrlStatusReg_t;

//------------------------------------------------------------------
// System event counter(SEC) register.
//------------------------------------------------------------------
#define MFI_SYS_EVT_CNT_REG                      (0x4D)

//------------------------------------------------------------------
// Apple device certificate data length register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_LEN_REG             (0x50)

//------------------------------------------------------------------
// Apple device certificate data page1 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE1_REG           (0x51)

//------------------------------------------------------------------
// Apple device certificate data page2 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE2_REG           (0x52)

//------------------------------------------------------------------
// Apple device certificate data page3 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE3_REG           (0x53)

//------------------------------------------------------------------
// Apple device certificate data page4 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE4_REG           (0x54)

//------------------------------------------------------------------
// Apple device certificate data page5 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE5_REG           (0x55)

//------------------------------------------------------------------
// Apple device certificate data page6 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE6_REG           (0x56)

//------------------------------------------------------------------
// Apple device certificate data page7 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE7_REG           (0x57)

//------------------------------------------------------------------
// Apple device certificate data page8 register.
//------------------------------------------------------------------
#define MFI_APPLE_CERTI_DATA_PAGE8_REG           (0x58)

//Old definition
#define kMFiAuthReg_AuthControlStatus			0x10
#define kMFiAuthFlagError						0x80
#define kMFiAuthControl_GenerateSignature		1
#define kMFiAuthReg_SignatureSize				0x11
#define kMFiAuthReg_SignatureData				0x12
#define kMFiAuthReg_ChallengeSize				0x20
#define kMFiAuthReg_ChallengeData				0x21
#define kMFiAuthReg_DeviceCertificateSize		0x30
#define kMFiAuthReg_DeviceCertificateData1		0x31 // Note: auto-increments so next read is Data2, Data3, etc.

//------------------------------------------------------------------
// Error codes.
//------------------------------------------------------------------
typedef enum {
    CP_NO_ERROR              = 0x00, //No error.
    CP_INVALID_RDREG         = 0x01, //Invalid register for read.
    CP_INVALID_WRREG         = 0x02, //Invalid register for write.
    CP_INVALID_SIGNATURE_LEN = 0x03, //Invalid signature length.
    CP_INVALID_CHALLENGE_LEN = 0x04, //Invalid challenge length.
    CP_INVALID_CERTI_LEN     = 0x05, //Invalid certificate length.
    CP_SIGNATURE_GENER_ERR   = 0x06, //Internal process error during signature generation.
    CP_CHALLENGE_GENER_ERR   = 0x07, //Internal process error during challenge generation.
    CP_SIGNATURE_VERIFY_ERR  = 0x08, //Internal process error during signature verification.
    CP_CHALLENGE_VERIFY_ERR  = 0x09, //Internal process error during challenge verification.
    CP_INVALID_PROCESS_CTRL  = 0x0A, //Invalid process control.
    CP_CTRL_OUT_OF_SEQ       = 0x0B, //Process control out of sequence.
} eCpErrCode_t;


//APIs
void GetSignatureData( const void *inChallengePtr, unsigned int inChallengeLen, 
		               unsigned char **outSignaturePtr, unsigned int *outSignatureLen );
void GetCertificate(unsigned char **outCertificatePtr, unsigned int *outCertificateLen);


#ifdef __cplusplus
		}//extern "C" 
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
