/*********************************************************************************************************
*                                         Stream processing
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: stream.h
* Version	: V1.0.0
* Brief:    : This file contains all the functions prototypes for processing the audio stream.
* ---------------
**********************************************************************************************************/
#ifndef _STREAM_H
#define _STREAM_H
    
#include <stdint.h>
#include "streamQueue.h"
#include "streamAirplay_cfg.h"
    
#ifdef __cplusplus
        extern "C" {
#endif

#define STREAMING_OK                     (0)
#define STREAMING_ERR_NO_MEMORY          (-1)
#define STREAMING_ERR_INVALID_PARAM      (-2)
#define STREAMING_ERR_NOT_INITIALIZED    (-3)

typedef struct _tStreamingParam_t{
    uint32_t Rate;               // 44100
    uint16_t SamplePairPerFrame; // 352
    uint16_t SamplePairSize;     // 4
    uint16_t FrameSize;          // MEDIA_SAMPLE_PAIR_PER_FRAME * MEDIA_SAMPLE_PAIR_SIZE
    uint16_t FrameMax;           // 8 was 24
    uint16_t FrameWaitMS;        // 1
    uint16_t DmaSize;
    uint16_t FrameTarget;
    uint16_t FrameHighWM;
    uint16_t FrameLowWM;
    bool     Allocated;
} tStreamingParam;

//=====================
// Debug statistics
//=====================
typedef struct _tMediaStatistics_t {
    u8 MediaHeadPnt;
    u8 MediaTailPnt;
    u8 MediaNum;
    u8 MediaNumLow;
    u8 MediaNumHigh;
    u32 MediaOverflowMS;
    u32 MediaOverflow;
    u32 MediaEmpty;
    int MediaOffset;
    bool MediaCritical;
} tMediaStatistics;

//------------------------------------------------------------------
// Media frame buffer structure.
//------------------------------------------------------------------
typedef struct _mediaFrameBuf_t{
    streamNode_t node;
    uint8_t buf[SAMPLE_PAIR_PER_FRAME * SAMPLE_PAIR_SIZE];
} mediaFrameBuf_t;

//------------------------------------------------------------------
// Media buffer structure.
//------------------------------------------------------------------
typedef struct _mediaBuf_t {
    streamList_t list;
    mediaFrameBuf_t frame[FRAME_BUF_MAX];
    uint32_t frameCnt;
} mediaBuf_t;

//APIs
void Streaming_ReceiveMedia(uint16_t seq, uint8_t* sample);
void airplay_PlayAudio(void* arg);

#ifdef __cplusplus
		}//extern "C" 
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
