/*********************************************************************************************************
*                                       UART stream structure
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: streamUart.h
* Version	: V1.0.0
* Brief:    : This file contains all the functions prototypes for the UART stream.
**********************************************************************************************************/
#ifndef __STREAMUART_H
#define __STREAMUART_H
    
#ifdef __cplusplus
     extern "C" {
#endif
    
#include <stdint.h>
#include "streamList.h"
#include "streamUart_cfg.h"

//------------------------------------------------------------------
// UART block structure.
//------------------------------------------------------------------
typedef struct _uartBlock_t {
    streamNode_t node;
    uint32_t     payload;
    uint8_t      buf[UART_BLOCK_SIZE_BYTE];
} uartBlock_t;

//------------------------------------------------------------------
// UART pool structure.
//------------------------------------------------------------------
typedef struct _uartPool_t {
    streamList_t idleList;
    streamList_t usedList;
    streamList_t sendList;
    uartBlock_t  block[UART_BLOCK_CNT];
} uartPool_t;

#ifdef __cplusplus
		}//extern "C" 
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
