/*********************************************************************************************************
*                                     Stream Queue Configuration
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : streamQueue_cfg.h
* Version : V1.0.0
* Brief   : This file contains all the function configuration for stream queue.
* ----------------
* You can add some extra functions when alloc or free buffers by modify hook functions.
**********************************************************************************************************/
#ifndef _STREAMQUEUE_CFG_H
#define _STREAMQUEUE_CFG_H

#ifdef __cplusplus
	extern "C" {
#endif

//------------------------------------------------------------------
// Block size.
//------------------------------------------------------------------
#if defined(AVS) || defined(DUER)
#define STREAM_WEB_BLOCK_SIZE_BYTE          (sizeof(H2RxStreamCtrlInfo_t))
#define STREAM_HDR_BLOCK_SIZE_BYTE          (sizeof(H2RxHdrCtrlInfo_t) + 256)
#define STREAM_BDY_BLOCK_SIZE_BYTE          (sizeof(H2RxBdyCtrlInfo_t) + 1500)
#define STREAM_REC_BLOCK_SIZE_BYTE          (1280)
#define MP3_STREAM_SRC_BLOCK_SIZE_BYTE      (512)
#define MP3_STREAM_PCM_BLOCK_SIZE_BYTE      (128) //Don't change this size to another number.
#endif  //endif defined(AVS || DUER)
#if defined(MP3_DEMO)
#define MP3_STREAM_SRC_BLOCK_SIZE_BYTE      (512)
#define MP3_STREAM_PCM_BLOCK_SIZE_BYTE      (128) //Don't change this size to another number.
#endif  //endif defined(MP3_DEMO)
#if defined(RADIO_DECODER)
#define MP3_STREAM_SRC_BLOCK_SIZE_BYTE      (512)
#define MP3_STREAM_PCM_BLOCK_SIZE_BYTE      (128) //Don't change this size to another number.
#define M4A_STREAM_SRC_BLOCK_SIZE_BYTE      (1024)
#define M4A_STREAM_PCM_BLOCK_SIZE_BYTE      (8192) 
#endif  //endif defined(RADIO_DECODER)

//------------------------------------------------------------------
// Block amount.
//------------------------------------------------------------------
#if defined(AVS) || defined(DUER)
#define STREAM_WEB_BLOCK_CNT                (4)
#define STREAM_HDR_BLOCK_CNT                (8)
#define STREAM_BDY_BLOCK_CNT                (4)
#define STREAM_REC_BLOCK_CNT                (16)
#define MP3_STREAM_SRC_BLOCK_CNT            ((8 << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)//(((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufSize)) << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_SRC_LOWER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufLower)) << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_SRC_UPPER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufUpper)) << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_BLOCK_CNT            ((8 << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)//(((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufSize)) << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_LOWER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufLower)) << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_UPPER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufUpper)) << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#endif  //endif defined(AVS || DUER)
#if defined(MP3_DEMO)
#define MP3_STREAM_SRC_BLOCK_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufSize)) << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_SRC_LOWER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufLower)) << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_SRC_UPPER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufUpper)) << 10) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_BLOCK_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufSize)) << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_LOWER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufLower)) << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_UPPER_CNT            (((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufUpper)) << 10) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#endif  //endif defined(MP3_DEMO)
#if defined(RADIO_DECODER)
#define MP3_STREAM_SRC_BLOCK_CNT            ((((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_SrcBufSize)) << 10) << 3) / MP3_STREAM_SRC_BLOCK_SIZE_BYTE)
#define MP3_STREAM_PCM_BLOCK_CNT            ((((*(uint8_t*)TM_GetFlashReadPtr(VAR_ID_PcmBufSize)) << 10) << 3) / MP3_STREAM_PCM_BLOCK_SIZE_BYTE)
#define M4A_STREAM_SRC_BLOCK_CNT            (20)
#define M4A_STREAM_PCM_BLOCK_CNT            (4)
#endif  //endif defined(RADIO_DECODER)

#ifdef __cplusplus
	}//extern "C"
#endif
#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/
