/*********************************************************************************************************
*                                           Stream Queue
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : streamQueue.h
* Version : V1.0.0
* Brief   : This file contains all the functions prototypes for stream queue.
**********************************************************************************************************/
#ifndef _STREAMQUEUE_H
#define _STREAMQUEUE_H

#include <stdint.h>
#include "streamList.h"
#include "streamQueue_cfg.h"

#ifdef __cplusplus
	extern "C" {
#endif

//Hook enable.
#define streamBlockAllocHookEnable          (1)
#define streamBlockFreeHookEnable           (1)
#define streamBlockAddToWorkHookEnable      (1)
#define streamBlockGetUsedFirstHookEnable   (1)
#define streamBlockGetUsedLastHookEnable    (1)
#define streamBlockGetWorkFirstHookEnable   (1)
#define streamBlockGetWorkLastHookEnable    (1)
#define streamBlockGetNextBlockHookEnable   (1)
	  
//Block attribute options.
#define STREAM_BLOCK_EOF                    (0x01)
#define STREAM_BLOCK_TIMEOUT                (0x01)
#define STREAM_BLOCK_TYPE_CMD               (0x00)
#define STREAM_BLOCK_TYPE_DATA              (0x01)
#define STREAM_BLOCK_INTR                   (0x01)

//------------------------------------------------------------------
// Block flags.
//------------------------------------------------------------------
typedef union _streamBlockFlg_t {
    uint32_t attr;
    struct {
        uint32_t eof      : 1;
        uint32_t timeout  : 1;
        uint32_t type     : 1;
        uint32_t intr     : 1;
        uint32_t reserved : 28;
    } bits;
} streamBlockFlg_t;

//------------------------------------------------------------------
// Block structure.
//------------------------------------------------------------------
typedef struct _streamBlock_t {
    streamNode_t        node;
    uint32_t            payload;
    void                *rdPtr;
    void                *wrPtr;
    streamBlockFlg_t    flg;
    uint8_t             *buf;
} streamBlock_t;

//------------------------------------------------------------------
// Queue structure.
//------------------------------------------------------------------
typedef struct _streamQueue_t {
    streamList_t   idleList;
    streamList_t   usedList;
    streamList_t   workList;
    streamBlock_t  *block;
} streamQueue_t;

//------------------------------------------------------------------
// Parameter structure.
//------------------------------------------------------------------
typedef struct _streamParam_t {
    streamQueue_t *queue;
} streamParam_t;

//APIs.
streamQueue_t* streamQueueCreate(uint32_t bufSize, uint32_t blockNum);
void streamQueueDelete(streamQueue_t *queue);
uint32_t streamQueueGetIdleCnt(streamQueue_t *queue);
uint32_t streamQueueGetUsedCnt(streamQueue_t *queue);
uint32_t streamQueueGetWorkCnt(streamQueue_t *queue);
streamBlock_t* streamBlockAlloc(streamQueue_t *queue, void *param);
void streamBlockAddToWork(streamQueue_t *queue, streamBlock_t *block, void *param);
void streamBlockFree(streamQueue_t *queue, streamBlock_t *block, void *param);
void streamBlockFreeAll(streamQueue_t *queue, void *param);
streamBlock_t* streamBlockGetUsedFirst(streamQueue_t *queue, void *param);
streamBlock_t* streamBlockGetUsedLast(streamQueue_t *queue, void *param);
streamBlock_t* streamBlockGetWorkFirst(streamQueue_t *queue, void *param);
streamBlock_t* streamBlockGetWorkLast(streamQueue_t *queue, void *param);
streamBlock_t* streamBlockGetNextBlock(streamBlock_t *block, void *param);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

