/*********************************************************************************************************
*                                          List for stream
*                             COPYRIGHT(c) 2017 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File		: streamList.h
* Version	: V1.0.0
* Brief:    : This file contains all the functions prototypes for the stream list.
**********************************************************************************************************/
#ifndef __STREAMLIST_H
#define __STREAMLIST_H

#ifdef __cplusplus
 extern "C" {
#endif

#include <stdint.h>

//------------------------------------------------------------------
// Stream node structure.
//------------------------------------------------------------------
typedef struct _streamNode_t {
    struct _streamNode_t* nextNode;
} streamNode_t;

//------------------------------------------------------------------
// Stream list structure.
//------------------------------------------------------------------
typedef struct _streamList_t {
    streamNode_t headNode;
    streamNode_t tailNode;
    uint32_t     nodeCnt;
} streamList_t;

//Terminal node difinition.
#define streamFirstNode   headNode.nextNode
#define streamLastNode    tailNode.nextNode

//Get the node parent address.
#define streamNodeParentAddr(pNode, parentType)    (parentType*)((char*)pNode - (uint32_t)&((parentType*)0)->node)
//Get the list parent address.
#define streamListParentAddr(pList, parentType)    (parentType*)((char*)pList - (uint32_t)&((parentType*)0)->list)


//APIs
void streamNodeInit(streamNode_t* node);
void streamListInit(streamList_t* list);
uint32_t streamListCnt(streamList_t* list);
streamNode_t* streamListGetFirstNode(streamList_t* list);
streamNode_t* streamListGetLastNode(streamList_t* list);
void streamListAddFirstNode(streamList_t* list, streamNode_t* node);
void streamListAddLastNode(streamList_t* list, streamNode_t* node);
streamNode_t* streamListDelFirstNode(streamList_t* list);
streamNode_t* streamListDelLastNode(streamList_t* list);
void streamListDelSpecNode(streamList_t* list, streamNode_t* node);


#ifdef __cplusplus
		}//extern "C" 
#endif

#endif

/************************ (C) COPYRIGHT ART *****END OF FILE****/
