/*********************************************************************************************************
*                                       C Library API for mbed
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : mbed_lib.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for mbedtls connection.
**********************************************************************************************************/

#ifndef __MBED_LIB_H
#define __MBED_LIB_H

#include "mbedtls/config.h"
#include "mbedtls/platform.h"
#include "mbedtls/net_sockets.h"
#include "mbedtls/debug.h"
#include "mbedtls/ssl.h"
#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include "mbedtls/error.h"
#include "mbedtls/certs.h"

//------------------------------------------------
// Structure containing mbed connection context
// Contains SSL/TSL connection context.
//------------------------------------------------
typedef struct {
    mbedtls_net_context         server_fd;
    mbedtls_entropy_context     entropy;
    mbedtls_ctr_drbg_context    ctr_drbg;
    mbedtls_ssl_context         ssl;
    mbedtls_ssl_config          conf;
    mbedtls_x509_crt            cacert;
    const char *                protocol;
} mbed_ctx_t;

//-----------------------------------
// prototypes
//-----------------------------------
int mbed_connect_open(mbed_ctx_t *mctx, uint32_t port, char *hostname);
void mbed_connect_close(mbed_ctx_t *mctx);

#endif // __MBED_LIB_H

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

