/*********************************************************************************************************
*                                          Jtools library
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : jto_lib.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for Jtools.
**********************************************************************************************************/
#ifndef _JTO_LIB_H
#define _JTO_LIB_H

#include <stdint.h>
#include "ach118x_i2s.h"
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

#ifdef __cplusplus
	extern "C" {
#endif

//Jtools control information.
typedef struct _JtoCtrlInfo_t {
    I2S_TypeDef *I2Sx;//I2S device.
    volatile bool jtoRecIdleFlowCtrlStatus;
    volatile bool jtoRecWorkFlowCtrlStatus;
    xSemaphoreHandle jtoRecIdleFlowCtrlSem;
    xSemaphoreHandle jtoRecWorkFlowCtrlSem;
    char *refreshTokenBuf;
    char *accessTokenBuf;
    volatile bool recStatus;
    uint32_t recSizeMax;
    uint32_t recSize;
    volatile bool playStatus;
} JtoCtrlInfo_t;

//Variables.
extern JtoCtrlInfo_t jtoCtrlInfo;

//APIs.
void JtoCtrlInfoInit(JtoCtrlInfo_t* info);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

