/*********************************************************************************************************
*                                         Get file via http
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : httpDownloader.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for getting file via http.
**********************************************************************************************************/
#ifndef _HTTP_DOWNLOADER_H
#define _HTTP_DOWNLOADER_H

#include <stdint.h>
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

#ifdef __cplusplus
	extern "C" {
#endif

//Web file type.
typedef enum{WEB_UNKNOWN = 0, WEB_TXT = 1, WEB_MP3 = 2} webFileType_t;
//Web file status.
typedef enum{WEB_RCVING = 0, WEB_DONE = 1, WEB_DAMAGED = 2} webFileStatus_t;

typedef enum{WEB_INVALID = 0, WEB_HTTP = 1, WEB_HTTPS = 2} webTypt_t;


//Play list header.
typedef struct _utilFileHeader_t {
    uint32_t payload;
    char*    rdPtr;
    char*    wrPtr;
} utilFileHeader_t;

//Remote address.
typedef struct _httpRemoteAddr_t {
    char* host;
    char* path;
    webTypt_t  webtype;
} httpRemoteAddr_t;

//Http acknowledge status line.
typedef struct _httpAckStatus_t {
    char* protocol;
    uint32_t statusCode;
} httpAckStatus_t;

//Http acknowledge header item.
typedef struct _httpAckHeaderItem_t {
    char* type;
    char* value;
} httpAckHeaderItem_t;

//Http acknowledge header blank line.
typedef struct _httpAckHeaderBlankLine_t {
    char* type;
    uint8_t status;
} httpAckHeaderBlankLine_t;

//Http acknowledge header.
typedef struct _httpAckHeader_t {
    httpAckStatus_t status;
    httpAckHeaderItem_t date;
    httpAckHeaderItem_t server;
    httpAckHeaderItem_t last_modified;
    httpAckHeaderItem_t etag;
    httpAckHeaderItem_t accept_ranges;
    httpAckHeaderItem_t content_length;
    httpAckHeaderItem_t vary;
    httpAckHeaderItem_t connection;
    httpAckHeaderItem_t content_type;
    httpAckHeaderBlankLine_t blankLine;
} httpAckHeader_t;

//Http acknowledge header cache.
typedef struct _httpAckHeaderCache_t {
    char  buf[1024];
    uint32_t payload;
    char* wrPtr;
    char* rdPtr;
} httpAckHeaderCache_t;

//Download control information.
typedef struct _httpAccessCtrlInfo_t {
    xSemaphoreHandle accessCtrlSem;
    xQueueHandle remoteQueue;
    xQueueHandle accessResultQueue;
    uint8_t headerSplitSta;//Split http header with "\r\n" start flag.
    uint8_t headerSplitSto;//Split http header with "\r\n" stop flag.
    volatile webFileStatus_t fileStatus;//Downloading file status.
    webFileType_t fileType;//Downloading file type.
    uint32_t fileSize;//Downloading file size.
    uint32_t rdPayload;//Have downloaded size.
    httpAckHeaderCache_t cache;//Http ack header cache.
    uint8_t downloaderWorkStep;
} httpAccessCtrlInfo_t;

//Http accessing control information.
extern httpAccessCtrlInfo_t httpAccessCtrlInfo;
extern xQueueHandle xUtilFileQueue;

//APIs.
void httpAccessCtrlInfoClr(httpAccessCtrlInfo_t* info);
int getFileFromHttpFrame(void* buf, uint32_t len);
void vHttpAccessTask(void* pvParameters);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/
