#ifndef __dbg_h
#define __dbg_h

#include <stdio.h>

#define NDEBUG

#ifndef NDEBUG
#define debug(M, ...)
#else
#define debug(M, ...) fprintf(stderr, "DEBUG %s:%d:  " M "\r\n", __FUNCTION__, __LINE__, ##__VA_ARGS__)
#endif

#define jump_unless(A) if (!(A)) { goto error; }
#define error_unless(A, B) if (!(A)) { printf("%s\r\n", B); goto error; }

#endif
