/*********************************************************************************************************
*                                            AVS library
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : avs_lib.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for AVS.
**********************************************************************************************************/
#if defined(AVS) || defined(DUER)
#ifndef _AVS_LIB_H
#define _AVS_LIB_H

#include <stdint.h>
#include "streamQueue.h"
#include "h2_lib.h"

#ifdef __cplusplus
	extern "C" {
#endif

//AVS work state enum.
typedef enum {
    AVS_IDLE = 0,
    AVS_INIT_COMPONENT,
    AVS_GET_TOKEN,
    AVS_SET_API,
    AVS_H2_CONNECT,
    AVS_H2_DOWNCHANNEL,
    AVS_H2_SYNC_STATE,
    AVS_H2_PING,
    AVS_SPEECH_RECOG,
    AVS_SPEECH_SYNTH_STA,
    AVS_SPEECH_SYNTH_STO,
    AVS_WORKSTATE_NUM
} AVS_WorkState_t;

//AVS multipart type enum.
typedef enum {
    AVS_PARTTYPE_UNKNOWN = 0,
    AVS_PARTTYPE_JSON,
    AVS_PARTTYPE_OCTET_STREAM,
    AVS_PARTTYPE_UNEXPECT
} AVS_MultiType_t;

//AVS multipart status enum.
typedef enum {
    AVS_PARTSTATUS_NONE,
    AVS_PARTSTATUS_ONGOING,
    AVS_PARTSTATUS_DONE
} AVS_MultiStatus_t;

//AVS control information structure.
typedef struct _AvsCtrlInfo_t {
    AVS_WorkState_t previousState;
    AVS_WorkState_t currentState;
    AVS_WorkState_t nextState;
	uint8_t RestartCnt;
} AvsCtrlInfo_t;

//AVS boundary structure.
typedef struct _AvsH2Boundary_t {
    char *str;
    int len;
} AvsH2Boundary_t;

//AVS parse cache structure.
typedef struct _AvsParseCache_t {
    uint32_t cpyLen;
    uint32_t payload;
    uint8_t *rdPtr;
    uint8_t *wrPtr;
    uint8_t *buf;
} AvsParseCache_t;

//AVS multipart json.
typedef struct _AvsMultiJson_t {
    streamNode_t node;
    AVS_MultiStatus_t status;
    const char *string;
} AvsMultiJson_t;

//AVS multipart audio.
typedef struct _AvsMultiAudio_t {
    AVS_MultiStatus_t status;
    const char *start;
} AvsMultiAudio_t;

//AVS request user data structure.
typedef struct _AvsH2ReqUsrData_t {
    AVS_WorkState_t workState;
    uint32_t statusCode;
    AvsH2Boundary_t boundary;
    AVS_MultiType_t partType;
    streamList_t jsonList;
    AvsMultiAudio_t audio;
    uint32_t hdrCnt;
    uint32_t bdyCnt;
    AvsParseCache_t cache;
    const char *ptr;
} AvsH2ReqUsrData_t;

//Variables.
extern AvsCtrlInfo_t avsCtrlInfo;

//APIs.
void avsCtrlInfoInit(AvsCtrlInfo_t *ctrlInfo);
void avsParseCacheInit(AvsParseCache_t *cache);
void avsParseCacheClr(AvsParseCache_t *cache);
uint8_t* avsFillBdyPartToCache(AvsParseCache_t* cache, H2RxBdyCtrlInfo_t *bdyInfo);
AvsH2ReqUsrData_t* avsCreateStreamUsrData(AVS_WorkState_t work_state);
void avsDestroyStreamUsrData(AvsH2ReqUsrData_t *usr_data);
const char* avsExtractHdrItemOption(const char *info, const char *key);
void avsDistoryHdrItemOption(char *value);
const char* avsExtractBdyPartBoundary(AvsH2Boundary_t *boundary, const char *buf, const int len);
const char* avsExtractBdyPartEndBoundary(AvsH2Boundary_t *boundary, const char *buf, const int len);
AVS_MultiType_t avsExtractBdyPartType(const char *buf, const int len);
const char* avsExtractBdyPartMainMsg(const char *buf, const int len);
const char* avsExtractBdyPartJsonSta(const char *buf, const int len);
const char* avsExtractBdyPartJsonSto(AvsH2Boundary_t *boundary, const char *buf, const int len);
const char* avsExtractBdyPartJsonStr(AvsH2Boundary_t *boundary, const char *buf, const int len);
AvsMultiJson_t* avsMountBdyPartJsonStr(streamList_t *list, const char *string);
void avsDestoryBdyPartJsonStr(streamList_t *list, AvsMultiJson_t *json);
void avsDestoryBdyPartJsonStrAll(streamList_t *list);
AvsMultiJson_t* avsGetFirstBdyPartJsonStr(streamList_t *list);
AvsMultiJson_t* avsGetLastBdyPartJsonStr(streamList_t *list);
AvsMultiJson_t* avsGetNextBdyPartJsonStr(AvsMultiJson_t *json);
AvsMultiJson_t* avsSearchBdyPartJsonStrByName(streamList_t *list, const char *namespace, const char *name);
AvsMultiJson_t* avsSearchBdyPartJsonStrByStatus(streamList_t *list, AVS_MultiStatus_t status);
int avsCheckBdyPartJsonStrByName(AvsMultiJson_t *json, const char *namespace, const char *name);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

#endif
/******************************** (C) COPYRIGHT ART ****END OF FILE****/

