/*********************************************************************************************************
*                                     Node interface to MP3 demo
*                             COPYRIGHT(c) 2019 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : node_mp3_demo.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for MP3 demo.
**********************************************************************************************************/
#ifndef _NODE_MP3_DEMO_H
#define _NODE_MP3_DEMO_H

#include "streamList.h"

#ifdef __cplusplus
	extern "C" {
#endif

//AVS main message ID.
typedef enum{
    NODE_MSG_MP3_DEMO_CMD = NODE_MSG_MP3_DEMO_BASE,
    NODE_MSG_MP3_DEMO_NEXT,
    NODE_MSG_AVS_MAIN_NUM
} NodeAvsMainMsg_e;

//File information.
typedef struct _Mp3DemoFile_t {
    int payload;        //Content current payload.
    char *content;      //Content.
    char *wr_ptr;       //Content write pointer.
    char *rd_ptr;       //Content read pointer.
} Mp3DemoFile_t;

//Music information type.
typedef struct _Mp3DemoMusicInfo_t {
    streamNode_t node;
    char *file_name;
    char *music_name;
} Mp3DemoMusicInfo_t;

//Playlist type.
typedef streamList_t    Mp3DemoPlaylist_t;

//AT command parameters for every work state.
#define MP3_DEMO_STA_CMD         "start"
#define MP3_DEMO_NEXT_CMD        "next"

//Nodes.
void vNodeMp3Demo(void *pvParam);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

