/***********************************************************************************************
*                                              H2 node
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : node_h2.h
* Version : V1.0.0
* Brief   : Process H2 node messages, interfaces with the nghttp2 and mbedtls libraries.
************************************************************************************************/
#ifndef __NODE_H2_H
#define __NODE_H2_H

#include <stdint.h>
#include "nghttp2/nghttp2.h"
#include "node.h"

//AVS host.
#define AVS_HOST    "avs-alexa-na.amazon.com"
//DuerOS host.
#define DUER_HOST   "dueros-h2.baidu.com"

//Http2 main message IDs.
typedef enum {
    NODE_MSG_H2_CONNECT_REQ = NODE_MSG_H2_BASE,
    NODE_MSG_H2_CONNECT_RET,
    NODE_MSG_H2_DISCONNECT_REQ,
    NODE_MSG_H2_DISCONNECT_RET,
    NODE_MSG_H2_MAX
} NodeH2MainMsg_e;

//Http2 tx message IDs.
typedef enum {
    NODE_MSG_H2_TX_REQ = NODE_MSG_H2_MAX,
    NODE_MSG_H2_UPDATE_REQ,
    NODE_MSG_H2_PING_REQ,
    NODE_MSG_H2_TX_MAX
} NodeH2TxMsg_e;

//Http2 rx message IDs.
typedef enum {
    NODE_MSG_H2_RX_REQ = NODE_MSG_H2_TX_MAX,
    NODE_MSG_H2_RX_MAX
} NodeH2RxMsg_e;


//Http2 send message structure type.
typedef struct _H2SendMsg_t {
    nghttp2_nv *hdr;
    uint8_t hdr_len;
    nghttp2_data_provider *bdy;
    void* usr_data;
} H2SendMsg_t;

//APIs.
void vNodeH2Main(void *pvParam);
void vNodeH2Tx(void *pvParam);
void vNodeH2Rx(void *pvParam);

#if 0
//----------------------------------------------
// Node to receive h2 header information
//----------------------------------------------
extern NodeId_e HeaderNodeID;

//-----------------------------------------------
// NODE_MSG_H2_CONNECT
//-----------------------------------------------
typedef struct {
    char *hostname;
} NodeMsgH2_Connect_t;


//-----------------------------------------------
// NODE_MSG_H2_SUBMIT
//-----------------------------------------------
typedef struct {
    nghttp2_nv *pHdrs;
    uint8_t     hdr_len;
    uint32_t    WinSize;
} NodeMsgH2_Submit_t;


//-----------------------------------------------
// NODE_MSG_H2_GETFILE
//-----------------------------------------------
typedef struct {
    char *path;
} NodeMsgH2_Getfile_t;


//-----------------------------------------------
// NODE_MSG_H2_DATA_RCV
//-----------------------------------------------
typedef struct {
    int32_t stream_id;
    const uint8_t *data;
    size_t len;
} NodeMsgH2_DataRcv_t;



//-----------------------------------------------
// prototypes
//-----------------------------------------------
void vNodeH2(void* pvParam);
void h2_stream_close_callback(int32_t stream_id);
void h2_data_recv_callback(int32_t stream_id, const uint8_t *data, size_t len);
NodeId_e h2_stream_getnode(int32_t stream_id);
#endif

#endif // __NODE_H2_H
/******************************** (C) COPYRIGHT ART ****END OF FILE****/

