/***********************************************************************************************
*                                          Debug Node
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : node_debug.h
* Version : V1.0.0
* Brief   :
************************************************************************************************/
#ifndef __NODE_DEBUG_H
#define __NODE_DEBUG_H

#include "ach118x_timer.h"

typedef struct
{
    vu32 RESET_REG;                     // 0x00
    vu32 CFG_REG0;                      // 0x04
    vu32 EXT_CLK_DIV_REG;               // 0x08
    vu32 CLK_CTRL_REG0;                 // 0x0C
    vu32 CLK_CTRL_REG1;                 // 0x10
    vu32 CODEC_SCAN_INP_REG0;           // 0x14
    vu32 CODEC_SCAN_INP_REG1;           // 0x18
    vu32 MEM_TEST_SECTOR0_REG0;         // 0x1C
    vu32 MEM_TEST_SECTOR0_REG1;         // 0x20
    vu32 MEM_TEST_SECTOR0_REG2;         // 0x24
    vu32 MEM_TEST_SECTOR1_REG0;         // 0x28
    vu32 MEM_TEST_SECTOR1_REG1;         // 0x2C
    vu32 MEM_TEST_SECTOR1_REG2;         // 0x30
    vu32 MEM_TEST_SECTOR2_REG0;         // 0x34
    vu32 MEM_TEST_SECTOR2_REG1;         // 0x38
    vu32 MEM_TEST_SECTOR2_REG2;         // 0x3C
    vu32 MPU_COUNTER_REG;               // 0x40
    vu32 INTR_POLARITY_REG;             // 0x44
    vu32 SYS_LEV_INTR_MASK_REG;         // 0x48
    vu32 PLL0_REG0;                     // 0x4C
    vu32 PLL0_REG1;                     // 0x50
    vu32 Reserved_54;                   // 0x54
    vu32 PLL1_REG0;                     // 0x58
    vu32 PLL1_REG1;                     // 0x5C
    vu32 SPREAD_SPECTRUM_PLL1_REG;      // 0x60
    vu32 Reserved_64;                   // 0x64
    vu32 PERIPHERAL_RESET_ENB_REG;      // 0x68
    vu32 PAD_ENB_REG0;                  // 0x6C
    vu32 PAD_ENB_REG1;                  // 0x70
    vu32 CLK_STATUS_REG;                // 0x84
    vu32 INTR_STATUS_REG;               // 0x88
    vu32 PLL1_SPREAD_SPECTRUM_REG;      // 0x8C
    vu32 STATUS_REG0;                   // 0x90
    vu32 STATUS_REG1;                   // 0x94
    vu32 Reserved_94;                   // 0x98
    vu32 STATUS_REG2;                   // 0x9C
    vu32 CLK_ENB_REG;                   // 0xA0
    vu32 Reserved_A4;                   // 0xA4
    vu32 CODEC_SCAN_OUT_REG0;           // 0xA8
    vu32 CODEC_SCAN_OUT_REG1;           // 0xAC
} SysCfg_TypeDef;

#define APB1_PERIPH_BASE        0x40030000U                 // 0x4003 xxxx
#define SYSCFG_REG_BASE         (APB1_PERIPH_BASE | 0x5800) // 0x4003 5800
#define TIM_IRQ_MASK            0x00000200          // b9   Timer Interrupt mask
#define SYSCFG                  ((SysCfg_TypeDef *) SYSCFG_REG_BASE)    // 0x4003 5800


//-----------------------------------------------
// Messages IDs between tasks/nodes or to self
//-----------------------------------------------
typedef enum {
    NODE_MSG_DEBUG_TIMER_START = NODE_MSG_DEBUG_BASE,
    NODE_MSG_DEBUG_TIMER_STOP,
    NODE_MSG_DEBUG_TRIGGER,
    NODE_MSG_DEBUG_REPORT,
    NODE_MSG_DEBUG_MAX
} NodeMsgDebug_e;



//-----------------------------------------------
//
//-----------------------------------------------
typedef struct {
    uint16_t    dataLength;
    char        Data[];
} NodeMsgDebug_rx_t;



//-----------------------------------------------
// prototypes
//-----------------------------------------------
void vDebug(void* pvParam);
void node_debug_log(int16_t sample);


#endif // __NODE_DEBUG_H

/******************************** (C) COPYRIGHT ART ****END OF FILE****/


