/***********************************************************************************************
*                                          Console Node
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : node_console.h
* Version : V1.0.0
* Brief   :
************************************************************************************************/
#ifndef __NODE_CONSOLE_H
#define __NODE_CONSOLE_H


//-----------------------------------------------
// Messages IDs between tasks/nodes or to self
//-----------------------------------------------
typedef enum {
    NODE_MSG_CONSOLE = NODE_MSG_CONSOLE_BASE,
    NODE_MSG_CONSOLE_RX_UART,
    NODE_MSG_CONSOLE_RX_BYPASS,
    NODE_MSG_CONSOLE_MAX
} NodeMsgConsole_e;



//-----------------------------------------------
// NODE_MSG_CONSOLE_RX_UART
//-----------------------------------------------
typedef struct {
    uint16_t    dataLength;
    char        Data[];
} NodeMsgConsole_rx_t;


//-----------------------------------------------
// external prototypes
//-----------------------------------------------
void SendStringToConsoleNode(char *s, uint32_t len);
void AT_CollectCommandString(u8 *pData, u16 RxLen);
void AT_SetCommandMode(void);
void AT_SetBypassMode(void);
bool AT_BypassMode(void);
bool AT_CommandMode(void);


//-----------------------------------------------
// prototypes
//-----------------------------------------------
void vConsole(void* pvParam);
void vConsole(void* pvParam);

#endif // __NODE_CONSOLE_H

/******************************** (C) COPYRIGHT ART ****END OF FILE****/


