/*********************************************************************************************************
*                                   Node interface to AVS manager
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : node_avs.h
* Version : V1.0.0
* Brief   : Node interface to AVS manager.
**********************************************************************************************************/
#ifndef _NODE_AVS_H
#define _NODE_AVS_H

#include "node.h"

#ifdef __cplusplus
	extern "C" {
#endif

#define PINGPERIOD	    (60 * 1000)                 //Period 1min. Used for ping.
#if defined(AVS)
#define AVSRESTART_MAX	(30 * 60 * 1000)            //Period 30min. Used for refresh token.
#define AVSRESTART_MIN	(1 * 60 * 1000)             //Period 1min. Used for refresh token when fail.
#define AVSRESTART_CNT	(30)                        //Max retry times for refresh token.
#elif defined(DUER)
#define AVSRESTART_MAX	(24 * 24 * 60 * 60 * 1000)  //Period 24days. Used for refresh token.
#define AVSRESTART_MIN	(10 * 60 * 1000)            //Period 10min. Used for refresh token when fail.
#define AVSRESTART_CNT	(144)                       //Max retry times for refresh token.
#endif

//AVS main message ID.
typedef enum{
    NODE_MSG_AVS_CMD = NODE_MSG_AVS_BASE,
    NODE_MSG_AVS_INIT_OK,
    NODE_MSG_AVS_INIT_FAIL,
    NODE_MSG_AVS_JTO_OK,
    NODE_MSG_AVS_JTO_FAIL,
    NODE_MSG_AVS_API_OK,
    NODE_MSG_AVS_API_FAIL,
    NODE_MSG_AVS_H2_CONNECT_OK,
    NODE_MSG_AVS_H2_CONNECT_FAIL,
    NODE_MSG_AVS_H2_DOWNCHANNEL_OK,
    NODE_MSG_AVS_H2_DOWNCHANNEL_FAIL,
    NODE_MSG_AVS_H2_SYNC_STATE_OK,
    NODE_MSG_AVS_H2_SYNC_STATE_FAIL,
    NODE_MSG_AVS_H2_PING_STATE_OK,
    NODE_MSG_AVS_H2_PING_STATE_FAIL,
    NODE_MSG_AVS_MRP,
    NODE_MSG_AVS_SPEECH_RECOG,
    NODE_MSG_AVS_SPEECH_RECOG_OK,
    NODE_MSG_AVS_SPEECH_RECOG_FAIL,
    NODE_MSG_AVS_SPEECH_SYNTH_STA_OK,
    NODE_MSG_AVS_SPEECH_SYNTH_STA_FAIL,
    NODE_MSG_AVS_SPEECH_SYNTH_STO_OK,
    NODE_MSG_AVS_SPEECH_SYNTH_STO_FAIL,
    NODE_MSG_AVS_MAIN_NUM
} NodeAvsMainMsg_e;

//AVS tx message ID.
typedef enum{
    NODE_MSG_AVS_PARSE = NODE_MSG_AVS_MAIN_NUM,
    NODE_MSG_AVS_PARSE_NUM
} NodeAvsParseMsg_e;

//AT command parameters for every work state.
#define AVS_STA_CMD         "start"
#define AVS_STO_CMD         "stop"
#define AVS_SPEAK_CMD       "speak"
#define AVS_AUTH_CMD        "authok"

//Nodes.
void vNodeAvsMain(void* pvParam);
void vNodeAvsParse(void *pvParam);

#ifdef __cplusplus
	}//extern "C"
#endif

#endif

/******************************** (C) COPYRIGHT ART ****END OF FILE****/

