/*********************************************************************************************************
*                                      AVS authentication task
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : node.h
* Version : V1.0.0
* Brief   : This file contains all the structure and function prototypes
*           for node/tasks information.
**********************************************************************************************************/
#ifndef __NODE_H
#define __NODE_H

#include <stdint.h>
#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"
#include "custom.h"

#ifdef __cplusplus
	extern "C" {
#endif

//-----------------------------------------------
// Priorities
//-----------------------------------------------
#define NODE_PRI_NORMAL             5

//-----------------------------------------------
// Node is a task or a group of tasks
//-----------------------------------------------
typedef enum {
    NODE_ID_NULL=0,
    NODE_ID_CONSOLE,
    NODE_ID_DEBUG,
#if defined(_JTO)
    NODE_ID_JTO,
#if defined(AVS) || defined(DUER)
    NODE_ID_AVS_MAIN,
    NODE_ID_AVS_PARSE,
    NODE_ID_H2_MAIN,
    NODE_ID_H2_TX,
    NODE_ID_H2_RX,
    NODE_ID_AUDIO,
    NODE_ID_ALERT,
    NODE_ID_LED,
    NODE_ID_MRP,
#endif  //endif defined(AVS || DUER)
#endif  //endif defined(_JTO)
#if defined(MP3_DEMO)
    NODE_ID_LED,
    NODE_ID_MP3_DEMO,
#endif  //endif defined(MP3_DEMO)
#if defined(WCT)
    NODE_ID_LED,
    NODE_ID_MRP,
#endif  //endif defined(WCT)
#if defined(PICO)
	NODE_ID_PICO,
#endif
    NODE_ID_APP,
#if defined(AUDIO_APP)
    NODE_ID_WAVE_PLAYER,
#endif
#if defined(FIREBASE_CLIENT)
    NODE_ID_FBAPP,
#endif
    NODE_ID_MAX
} NodeId_e;

//-----------------------------------------------
// Messages IDs between tasks/nodes or to self
//-----------------------------------------------
typedef enum {
    NODE_MSG_TEST=1,
    NODE_MSG_EXIT,
    //-----
    NODE_MSG_H2_BASE       = 100,
    NODE_MSG_AVS_BASE      = 200,
    NODE_MSG_MRP_BASE      = 300,
    NODE_MSG_AUDIO_BASE    = 400,
    NODE_MSG_ALERT_BASE    = 500,
	NODE_MSG_JTO_BASE	   = 700,
	NODE_MSG_CONSOLE_BASE  = 800,
	NODE_MSG_MP3_DEMO_BASE = 900,
	NODE_MSG_DEBUG_BASE    = 1100,
	NODE_MSG_PICO_BASE	   = 1200,
    //-----
    NODE_MSG_MAX
} NodeMsg_e;

//-----------------------------------------------
// Node/Task information
//-----------------------------------------------
typedef struct {
    char *name;
    void (*vTask)(void *);
    int stackSize;
    int priority;
    int qDepth;
    TaskHandle_t xTaskHandle;
    QueueHandle_t xQueueHandle;
} NodeInfo_t;
extern NodeInfo_t nodeInfo[];

//-----------------------------------------------
// Node/Task Message structure
//-----------------------------------------------
typedef struct {
    NodeId_e FromNode;
    uint16_t MsgId;
    void    *pMsgData;
} NodeMsg_t;

//-----------------------------------------------
// prototypes
//-----------------------------------------------
int nodeCreate(NodeId_e NodeId);
int nodeSend(NodeId_e To, NodeId_e From, uint16_t MsgId, void *data);
int nodeSendFromISR(NodeId_e To, uint16_t MsgId, void *pData);
int nodeExit(NodeId_e To, NodeId_e From);


//-----------------------------------------------
// Other node definitions
//-----------------------------------------------
#include "node_utils.h"
#include "node_console.h"
#include "node_debug.h"
#if defined(_JTO)
#include "node_jto.h"
#if defined(AVS) || defined(DUER)
#include "node_avs.h"
#include "node_h2.h"
#include "node_led.h"
#include "node_mrp.h"
#endif  //endif defined(AVS || DUER)
#endif  //endif defined(_JTO)
#if defined(MP3_DEMO)
#include "node_led.h"
#include "node_mp3_demo.h"
#endif  //endif defined(MP3_DEMO)

#ifdef __cplusplus
	}//extern "C"
#endif

#endif // __NODE_H

/******************************** (C) COPYRIGHT ART ****END OF FILE****/


