#ifndef __H2_SESSION_LIB_H
#define __H2_SESSION_LIB_H

#include "mbedtls/ssl.h"
#include <nghttp2/nghttp2.h>


#define ARRLEN(x) (sizeof(x) / sizeof(x[0]))


#define STREAM_MAX 5
#define STREAM_TYPE_GENERIC 0
#define STREAM_TYPE_MP3     1
#define STREAM_TYPE_SPEECH  2


//-------------------------------------------------------------------
// stream data
//-------------------------------------------------------------------
typedef struct {
    uint32_t    id;
    uint8_t     type;
    uint32_t    recv_count;
} h2stream_t;


//-------------------------------------------------------------------
// structure for http2 session. This contains the nghttp2 context,
// server endpoint info, and SSL context.
//-------------------------------------------------------------------
typedef struct {
    nghttp2_session     *session;
    mbedtls_ssl_context *ssl;
    char host[64];
    int stream_count;
    h2stream_t  stream[STREAM_MAX];
} h2session_t;



//-------------------------------------------------------------------------
// These macros are used to construct a header table
//-------------------------------------------------------------------------
#define NAME_VALUE(NAME, VALUE)                                           \
  {                                                                       \
    (uint8_t *)NAME, (uint8_t *)VALUE, sizeof(NAME) - 1, strlen(VALUE),   \
        NGHTTP2_NV_FLAG_NONE                                              \
  }
//-------------------------------------------------------------------------



//-----------------------------------
// prototypes
//-----------------------------------
h2session_t *h2_create_session_data(mbedtls_ssl_context *ssl, char *hostname);
void h2_free_session_data(h2session_t *connection);


#endif // __H2_SESSION_LIB_H
