#ifndef __H2_LIB_H
#define __H2_LIB_H

#include "mbedtls/ssl.h"
#include <nghttp2/nghttp2.h>


#define ARRLEN(x) (sizeof(x) / sizeof(x[0]))


//-------------------------------------------------------------------
// structure for http2 session. This contains the nghttp2 context,
// server endpoint info, and SSL context.
//-------------------------------------------------------------------
typedef struct {
    nghttp2_session     *session;
    mbedtls_ssl_context *ssl;
    char scheme[8];
    char Authority[64];
    char Path[64];
    int32_t stream_id;
    int stream_open;
} h2connection_t;



//-------------------------------------------------------------------------
// These macros are used to construct a header table
//-------------------------------------------------------------------------
#define NAME_VALUE(NAME, VALUE)                                           \
  {                                                                       \
    (uint8_t *)NAME, (uint8_t *)VALUE, sizeof(NAME) - 1, strlen(VALUE),   \
        NGHTTP2_NV_FLAG_NONE                                              \
  }
//-------------------------------------------------------------------------



//-----------------------------------
// prototypes
//-----------------------------------
h2connection_t *h2_create_connection_data(mbedtls_ssl_context *ssl, char *hostname, char *path);
void h2_free_connection_data(h2connection_t *connection);


#endif // __H2_LIB_H
