/*********************************************************************************************************
*                                        Button application
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : myButton.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for button application.
**********************************************************************************************************/
#ifndef __MYBUTTON_H
#define __MYBUTTON_H

#include "FreeRTOS.h"
#include "task.h"
#include "semphr.h"

#define WOBBLE_TIME           (20)    //Wobble time. Default is 20ms.
#define GET_KEY_PERIOD        (10)    //Check time space. Default is 10ms.
#define LONG_PRESS_TIME       (5000)  //Long press threshold. Default is 5000ms.
#define DOUBLE_CLICK_TIME     (400)   //Double click threshold. Default is 400ms.

//Need long press.
#define LONG_PRESS_CHECK

//Need double click.
#define xDOUBLE_CLICK_CHECK

//Press count +1 when up or down. Only REACTE_WHEN_UP is OK when enable long press or double click.
#define REACTE                REACTE_WHEN_UP

//Button message enum.
typedef enum{MUSIC_STO = 0, MUSIC_STA = 1, MUSIC_NEXT = 2} playerButtonMsg_t;

//Button information.
typedef struct _buttonInfo_t {
    unsigned char msg;
    xQueueHandle msgQueue;
    struct {
        uint8_t respStatus : 1;   //Response status.
        uint8_t reserved   : 7;   //Reserved.
    } flgs;
} buttonInfo_t;

//Control information.
extern buttonInfo_t playerCtrlInfo;

//APIs.
unsigned char cbOfKey1(void);
unsigned char cbOfKey2(void);
void buttonGpioCfg(void);
void vButtonCtrlTask(void *pvParameters);

#endif
