/*********************************************************************************************************
*                                           Button Driver
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : button.h
* Version : V1.0.0
* Brief   : This file contains all the function prototypes for button driver.
**********************************************************************************************************/

#ifndef _BUTTON_H
#define _BUTTON_H

#include "myButton.h"

//Call back type of button state.
typedef unsigned char  (*KEY_CALLBACK_PTR)(void);

//Button type.
typedef struct KEY_Type KEY_Type;

struct KEY_Type { 
	//Call back of button state.
	KEY_CALLBACK_PTR   cbOfKey;
	//Button current state.
	unsigned char      State;
	//Wobble time.
	unsigned char      WobbleTimeCnt;
	//Stable time.
	unsigned int       StableTimeCnt;
	//Press times.
	unsigned char      KeyPressTimes;
	
#ifdef LONG_PRESS_CHECK
	//Long press times.
	unsigned char      KeyLongPressTimes;
#endif
	
#ifdef DOUBLE_CLICK_CHECK	
	//Double click times.
	unsigned char      KeyDoubleCklickTimes;
#endif
};

//Button state.
#define KEY_UP                      (0)//Button up.
#define KEY_DOWN_WOBBLE             (1)//Button down wobble.
#define KEY_DOWN                    (2)//Button down.
#define KEY_UP_WOBBLE               (3)//Button up wobble.
#define KEY_DOUBLE_CLICK_WOBBLE1    (4)//Button click wobble1.
#define KEY_DOUBLE_CLICK_WOBBLE2    (5)//Button click wobble2.
#define KEY_DOUBLE_CLICK_WOBBLE3    (6)//Button click wobble3.

//Count state.
#define REACTE_WHEN_DOWN            (0)
#define REACTE_WHEN_UP              (1)

//Clear after check.
#define CLEAR                       (1)

//Button check state.
#define ELEMENT_STATE               (0)
#define ELEMENT_PRESS_TIMES         (1)

#ifdef  DOUBLE_CLICK_CHECK
#define ELEMENT_DOUBLE_CLICK        (2)
#endif

#ifdef  LONG_PRESS_CHECK
#define ELEMENT_LONG_PRESS          (3)
#endif

#if (defined DOUBLE_CLICK_CHECK) || (defined LONG_PRESS_CHECK) 
  #if REACTE == REACTE_WHEN_DOWN
	  #error "Cann't response when enable long press or double click, set REACTE to REACTE_WHEN_UP"
	#endif
#endif

//APIs.
void CreateKey(KEY_Type *p_Key,KEY_CALLBACK_PTR cbOfKey);
unsigned char RefreshKeyState(KEY_Type *p_Key);
int GetKeyElement(KEY_Type *p_Key,unsigned char Element,unsigned char Option);

#endif
