/***********************************************************************************************
*                                        at_cmd_table_defs.h
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : at_cmd_table_defs.h
* Version : V1.0.0
* Brief   : Used to execute AT commands from command table
************************************************************************************************/

#include "custom.h"

// Standard Commands
#ifdef FCC
DEFINE_CMD_TBL("testrf",           AT_CmdTestModule)             // FCC CE  //by cbq 20241024		
#endif
DEFINE_CMD_TBL("showfiles",        AT_CmdShowFiles)             // Show files list in flash
DEFINE_CMD_TBL("config",           AT_CmdConfig)                // Show set config vars
DEFINE_CMD_TBL("reset",            AT_CmdReset) 			    // Request reset
DEFINE_CMD_TBL("scan",             AT_CmdScan)				    // Find nearby Access Points
DEFINE_CMD_TBL("join",             AT_CmdJoin)                  // Join a network
DEFINE_CMD_TBL("unjoin",           AT_CmdUnjoin)  			    // Unjoin the AP
DEFINE_CMD_TBL("factoryinit",      AT_CmdFactoryInit)		    // Init factory val
DEFINE_CMD_TBL("showconnection",   AT_CmdShowConnection)	    // Get TCPIP connections
//DEFINE_CMD_TBL("sleep",            AT_CmdSleep)                 // ACH enter sleep mode
DEFINE_CMD_TBL("socketopen",       AT_CmdSocketOpen)            //open socket server
DEFINE_CMD_TBL("socketclose",      AT_CmdSocketClose)           //close socket server
DEFINE_CMD_TBL("setmacaddress",    AT_CmdSetMACAddress)         //open socket server
#if defined(AVS) || defined(DUER) || defined(MP3_DEMO) || defined(RADIO_DECODER) || defined(WCT) || defined(WUW) || defined(PICO)
DEFINE_CMD_TBL("showmusicbuf",     AT_CmdShowMusicBuf)
#else
//DEFINE_CMD_TBL("showbt",           AT_CmdShowBT)
//DEFINE_CMD_TBL("showfd",           AT_CmdShowFD)
//DEFINE_CMD_TBL("showcfg",          AT_CmdShowCfg)
//DEFINE_CMD_TBL("shownetwork",      AT_CmdShowNetwork)           // show network and ip address
DEFINE_CMD_TBL("showdev",          AT_CmdShowDevice)		    // get station list in AP mode
#endif
//DEFINE_CMD_TBL("showmem",          AT_CmdShowMem)	            // show memory states
DEFINE_CMD_TBL("showpool",         AT_CmdShowPool)

//DEFINE_CMD_TBL("showcpu",          AT_CmdShowCpu)
//DEFINE_CMD_TBL("beacon",           AT_CmdBeacon)
DEFINE_CMD_TBL("showversion",      AT_CmdShowVersion)           // build version
//Robert add for WF88M
#ifdef MQTT_CLIENT
DEFINE_CMD_TBL("mqttstart",        AT_CmdMqttStart)             //mqttstart
//DEFINE_CMD_TBL("shownetif",        AT_CmdShowNetif)             //ShowNetif
//DEFINE_CMD_TBL("mqttpub",          AT_CmdMqttPub)               //mqttpub
DEFINE_CMD_TBL("mqttdis",          AT_CmdMqttDis)               //mqttdis
DEFINE_CMD_TBL("mqttsub",          AT_CmdMqttUnSub)             //mqttunsub
//DEFINE_CMD_TBL("setipv6addrs",   AT_CmdSetIpv6addr)
#endif
//add end
//Robert add for WF88M gpio test
//DEFINE_CMD_TBL("gpio",              AT_CmdGpio)                 //test gpio
DEFINE_CMD_TBL("ping",              AT_CmdPing)                 //ping
DEFINE_CMD_TBL("pingstop",          AT_CmdPingStop)             //ping stop
DEFINE_CMD_TBL("flashloaderstart",  AT_CmdFlashloaderStart)
DEFINE_CMD_TBL("rmtcmdopen",        AT_CmdRemoteCmdOpen)            //open socket server
DEFINE_CMD_TBL("rmtcmdclose",       AT_CmdRemoteCmdClose)           //close socket server
#ifdef LWIPERF
DEFINE_CMD_TBL("iperfstart",        AT_Cmdiperfstart)
DEFINE_CMD_TBL("iperfstart_c",      AT_Cmdiperfstart_client)
#endif
#ifdef AUDIO_APP
DEFINE_CMD_TBL("audiostart",        AT_CmdStartAudio)
DEFINE_CMD_TBL("audiostop",        AT_CmdStopAudio)
#endif
#ifdef HTTPS_CLIENT
DEFINE_CMD_TBL("httpopen",        AT_CmdHttpOpen)
DEFINE_CMD_TBL("httpclose",       AT_CmdHttpClose)
DEFINE_CMD_TBL("httpget",         AT_CmdHttpGet)
DEFINE_CMD_TBL("httppost",        AT_CmdHttpPost)
#endif
#ifdef FIREBASE_CLIENT
DEFINE_CMD_TBL("gettime",        AT_CmdGetTime)
DEFINE_CMD_TBL("setaccessscope",  AT_CmdSetAccessScope)
DEFINE_CMD_TBL("getaccesstoken",  AT_CmdGetAccessToken)
DEFINE_CMD_TBL("fcmsend",  AT_CmdFcmSend)
//DEFINE_CMD_TBL("fcmcreategroup",  AT_CmdFcmGroupCreate)
//DEFINE_CMD_TBL("fcmmanagegroup",  AT_CmdFcmGroupManage)
#endif

// Add other commands here
#ifdef ENB_AT_TEST_CMDS
#include "at_test_cmds.h"
#endif

#if defined(AVS) || defined(DUER)
#include "at_avs_cmds.h"
#endif  //endif defined(AVS || DUER)

#if defined(MP3_DEMO)
#include "at_mp3demo_cmds.h"
#endif  //endif defined(MP3_DEMO)

#ifdef WCT
DEFINE_CMD_TBL("wct",			   AT_CmdWct)
#endif

#ifdef WUW
DEFINE_CMD_TBL("wuw",			   AT_CmdWuw)
#endif

#ifdef PICO
DEFINE_CMD_TBL("pico",			   AT_CmdPico)
#endif
