/***********************************************************************************************
*                                          at_cmd_table.h
*                             COPYRIGHT(c) 2018 Amped RF Technology (ART)
*                                        All Rights Reserved
*
* File    : at_cmd_table.h
* Version : V1.0.0
* Brief   : Used to execute AT commands from command table
************************************************************************************************/
#ifndef __AT_CMD_TABLE_H
#define __AT_CMD_TABLE_H

// AT command function type
typedef void (*tAtCmdFunc)(char **ppBuf);

// AT command table structure
typedef struct tAT_CmdTbl{
    const char  *pCmdStr;   // command string
    tAtCmdFunc  CmdFunc;    // command function
}tAT_CmdTbl;


// Command table
#define DEFINE_CMD_TBL(x,y) void y(char **ppBuf);
#include "at_cmd_table_defs.h"

/* Note: Instantiation is done in App node_utils.c */
#ifdef INSTANTIATE_CMD_TABLE
#undef DEFINE_CMD_TBL
#define DEFINE_CMD_TBL(x,y) {x, y},
const tAT_CmdTbl CommandTbl[]= {
#include "at_cmd_table_defs.h"
};
#define DEFINE_CMD_NUM (sizeof(CommandTbl)/sizeof(tAT_CmdTbl))
const int CommandNum=DEFINE_CMD_NUM;
#else
extern const tAT_CmdTbl CommandTbl[];
extern const int CommandNum;
#endif

#endif // __AT_CMD_TABLE_H
