/*
 *  linux/drivers/mmc/sdio_ops.c
 *
 *  Copyright 2006-2007 Pierre Ossman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 */

#ifndef _MMC_SDIO_OPS_H
#define _MMC_SDIO_OPS_H

#include <stdlib.h>
#include "string.h"
#include "stm32f4xx_lib.h"
#include "stm32_sdio_driver.h"
//#include "stm32f10x_sdio.h"

/* SDIO commands                         type  argument     response */
#define SD_IO_SEND_OP_COND          5 /* bcr  [23:0] OCR         R4  */
#define SD_IO_RW_DIRECT            52 /* ac   [31:0] See below   R5  */
#define SD_IO_RW_EXTENDED          53 /* adtc [31:0] See below   R5  */

#define MMC_CMD_RETRIES        3
#define MMC_CARD_BUSY	0x80000000	/* Card Power up status bit */

/* errors define*/
#define R5_COM_CRC_ERROR	(1 << 15)	/* er, b */
#define R5_ILLEGAL_COMMAND	(1 << 14)	/* er, b */
#define R5_ERROR		(1 << 11)	/* erx, c */
#define R5_FUNCTION_NUMBER	(1 << 9)	/* er, c */
#define R5_OUT_OF_RANGE		(1 << 8)	/* er, c */
#define R5_STATUS(x)		(x & 0xCB00)
#define R5_IO_CURRENT_STATE(x)	((x & 0x3000) >> 12) /* s, b */

#define	ETIMEDOUT	60	/* Connection timed out */
#define	EIO		 5	/* I/O error */
#define	EINVAL		22	/* Invalid argument */
#define	ERANGE		34	/* Math result not representable */

int mmc_send_io_op_cond( u32 ocr, u32 *rocr);
int mmc_io_rw_direct( int write, unsigned fn,
	unsigned addr, u8 in, u8* out);
int mmc_io_rw_extended( int write, unsigned fn,
	unsigned addr, int incr_addr, u8 *buf, unsigned blocks, unsigned blksz);
unsigned int mmc_align_data_size(struct mmc_card *card, unsigned int sz);
unsigned int sdio_align_size(struct sdio_func *func, unsigned int sz);

#endif

