#ifndef SER_DEBUG_H_INCLUDED
#define SER_DEBUG_H_INCLUDED
//#include "stm32f4xx_it.h"
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include "GKI_DataTypes.h"
// Defines
#ifndef NOP
#define NOP asm(" nop\n");
#endif

#define TM_BUF_SIZE  150//1500

#define DTRACE(x)   DbgTrace(__FUNCTION__, x)


typedef struct {
    u32 malloc_misses;
    u32 rcv_data;
    u32 snd_data;
	u32 dropped_data;
} tDbgStat;

extern tDbgStat DbgStat;

// DEBUG OPTIONS
#define DEBUG_SNDRCV_ENABLE     0

extern bool gRcvTestEnabled;
extern u32  gRcvTestRecCount;
extern u32  gRcvTestRecSize;
extern u32  gRcvTestMissCount;
extern u32  gRcvTestByteCount;
extern u32  gRcvTestRecSeq;
extern u32  gRcvTestMSTenths;
extern bool dtrace_enable;

//#define print_debug

void VeracityCheck(void);
void SerialPutChar(unsigned char c);
void SerialPutString(char *s);
#if 1
void dbg_buf(char* pcInput, unsigned long ulLen);
#else
void dbg_buf(const unsigned char *buf, size_t len);
#endif
#ifndef print_debug
#define printu(args...) do { } while (0)
#define printb(args...) do { } while (0)
#define prints(args...) do { } while (0)
#define printj(args...) do { } while (0)
#else
void printu(char *fmt, ...);
void printj(const char* fmt,...);//by cbq 20241129
void printb(const char* fmt,...);
void prints(char *fmt, ...);
#endif

#if 1
void WF_printu(char *fmt, ...);
#else
#define WF_printu(args...) do { } while (0)
#endif
void DbgTrace(char *, char *);
void dma_print(char *fmt, ...);


//
//----------------------------------------------------------------------------------------------
#endif
