/*
 * workqueue.h --- work queue handling for Linux.
 */
struct work_struct;
typedef void (*work_func_t)(struct work_struct *work);
struct work_struct {
//	atomic_long_t data;
//	struct list_head entry;
	work_func_t func;
#ifdef CONFIG_LOCKDEP
	struct lockdep_map lockdep_map;
#endif
};
/*
 * initialize a work item's function pointer
 */
#define PREPARE_WORK(_work, _func)				\
	do {							\
		(_work)->func = (_func);			\
	} while (0)

#define __INIT_WORK(_work, _func, _onstack)				\
	do {								\
/*												
		__init_work((_work), _onstack);				\
		(_work)->data = (atomic_long_t) WORK_DATA_INIT();	\
		INIT_LIST_HEAD(&(_work)->entry);			\
*/        								\
		PREPARE_WORK((_work), (_func));				\
	} while (0)

#define INIT_WORK(_work, _func)					\
	do {							\
		__INIT_WORK((_work), (_func), 0);		\
	} while (0)
