#ifndef SPINLOCK_H
#define SPINLOCK_H

#include "semphr.h"

typedef SemaphoreHandle_t spinlock_t;

#define spin_lock spin_lock_bh
#define spin_unlock spin_unlock_bh
static inline void spin_lock_init(spinlock_t *lock)
{
	if(*lock == NULL)
	{
//		*lock = xSemaphoreCreateMutex();
		vSemaphoreCreateBinary( *lock );
	}
}
static inline void spin_lock_bh(spinlock_t *lock)
{
	xSemaphoreTake( *lock, portMAX_DELAY );
}
static inline void spin_unlock_bh(spinlock_t *lock)
{
	xSemaphoreGive( *lock );
}

#endif