#ifndef KERNELTIMER_H
#define KERNELTIMER_H

#include "lwip/timeouts.h"

struct timer_list {
	/*
	 * All fields that change during normal runtime grouped to the
	 * same cacheline
	 */
	struct list_head entry;
	unsigned long expires;
	struct tvec_base *base;
#if 0
	void (*function)(unsigned long);
#else
    void (*function)(void *arg);
#endif
    unsigned long data;
	
	int slack;

#ifdef CONFIG_TIMER_STATS
	int start_pid;
	void *start_site;
	char start_comm[16];
#endif
#ifdef CONFIG_LOCKDEP
	struct lockdep_map lockdep_map;
#endif
};
#define del_timer_sync(t)		del_timer(t)
#define round_jiffies(x) x
static inline void setup_timer(struct timer_list * timer,
				void (*function)(void *arg), //void (*function)(unsigned long),
				unsigned long data)
{
	timer->function = function;
	timer->data = data;
//	init_timer_key(timer, name, key);
}



/**
 * del_timer - deactive a timer.
 * @timer: the timer to be deactivated
 *
 * del_timer() deactivates a timer - this works on both active and inactive
 * timers.
 *
 * The function returns whether it has deactivated a pending timer or not.
 * (ie. del_timer() of an inactive timer returns 0, del_timer() of an
 * active timer returns 1.)
 */
static inline int del_timer(struct timer_list *timer)
{
#if 0
	struct tvec_base *base;
	unsigned long flags;
	int ret = 0;

	timer_stats_timer_clear_start_info(timer);
	if (timer_pending(timer)) {
		base = lock_timer_base(timer, &flags);
		if (timer_pending(timer)) {
			detach_timer(timer, 1);
			if (timer->expires == base->next_timer &&
			    !tbase_get_deferrable(timer->base))
				base->next_timer = base->timer_jiffies;
			ret = 1;
		}
		spin_unlock_irqrestore(&base->lock, flags);
	}

	return ret;
#else
    sys_untimeout(timer->function, (void *)timer->data);
#endif
}
/**
 * mod_timer - modify a timer's timeout
 * @timer: the timer to be modified
 * @expires: new timeout in jiffies
 *
 * mod_timer() is a more efficient way to update the expire field of an
 * active timer (if the timer is inactive it will be activated)
 *
 * mod_timer(timer, expires) is equivalent to:
 *
 *     del_timer(timer); timer->expires = expires; add_timer(timer);
 *
 * Note that if there are multiple unserialized concurrent users of the
 * same timer, then mod_timer() is the only safe way to modify the timeout,
 * since add_timer() cannot modify an already running timer.
 *
 * The function returns whether it has modified a pending timer or not.
 * (ie. mod_timer() of an inactive timer returns 0, mod_timer() of an
 * active timer returns 1.)
 */
static inline int mod_timer(struct timer_list *timer, unsigned long expires)
{
//	printf("%s %d expires = %d %d ms %d ms\r\n", __func__, __LINE__, expires, jiffies_to_msecs(expires), expires - jiffies);
    sys_untimeout(timer->function, (void *)timer->data);
    sys_timeout( jiffies_to_msecs(expires - jiffies) , timer->function, (void *)timer->data);
}
/**
 * add_timer - start a timer
 * @timer: the timer to be added
 *
 * The kernel will do a ->function(->data) callback from the
 * timer interrupt at the ->expires point in the future. The
 * current time is 'jiffies'.
 *
 * The timer's ->expires, ->function (and if the handler uses it, ->data)
 * fields must be set prior calling this function.
 *
 * Timers with an ->expires field in the past will be executed in the next
 * timer tick.
 */
static inline int add_timer(struct timer_list *timer)
{
//	BUG_ON(timer_pending(timer));
	mod_timer(timer, timer->expires);
}
#endif