/*
 * mac80211 configuration hooks for cfg80211
 */
#ifndef __CFG_H
#define __CFG_H

extern struct cfg80211_ops mac80211_config_ops;
#define CONFIG_MAC80211_MESH

/*
 *	These inlines deal with timer wrapping correctly. You are 
 *	strongly encouraged to use them
 *	1. Because people otherwise forget
 *	2. Because if the timer wrap changes in future you won't have to
 *	   alter your driver code.
 *
 * time_after(a,b) returns true if the time a is after time b.
 *
 * Do this with "<0" and ">=0" to only test the sign of the result. A
 * good compiler would generate better code (and a really good compiler
 * wouldn't care). Gcc is currently neither.
 */
#define time_after(a,b)	((long)(b) - (long)(a) < 0)
//	(typecheck(unsigned long, a) && \
//	 typecheck(unsigned long, b) && \
//	 ((long)(b) - (long)(a) < 0))
#define time_before(a,b)	time_after(b,a)

#endif /* __CFG_H */
