//------------------------------------------------------------------------------
//
//  File name:    Kernel.h
//
//
//  Description:
//
//     Defines stuff particular to interpreting commands of the module.
//
//  Copyright (c) 2014 Amp'ed RF Tech Inc. All rights reserved.
//
//------------------------------------------------------------------------------
#ifndef  _KERNEL_H_
#define  _KERNEL_H_

#define offsetof(TYPE, MEMBER) ((unsigned int) &((TYPE *)0)->MEMBER)

struct sta_key{
	unsigned char addr[ETH_ALEN];
	struct ieee80211_key  *key;
};

#define container_of(ptr, type, member) (type *)( (char *)ptr - offsetof(type,member)) 

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(x) (sizeof(x)/sizeof((x)[0]))
#endif

#define __cpu_to_le16(x) (x)
#define __cpu_to_le32(x) (x)
#define __le16_to_cpu(x) (x)
#define __le32_to_cpu(x) (x)
#define __be16_to_cpu(x) (x)
#define unlikely(x) (x)
#define likely(x) (x)

#define WARN_ON(x) (x)

#define HZ 1000

extern TickType_t xTaskGetTickCount( void );
#define jiffies xTaskGetTickCount()
#define msecs_to_jiffies(ms) pdMS_TO_TICKS((ms))
#define jiffies_to_msecs(ms) pdMS_TO_TICKS((ms))

typedef unsigned char  u8;
typedef unsigned short  __le16;
typedef unsigned short  u16;

//typedef unsigned int    u32;

typedef unsigned short    __be16;
typedef unsigned int    __le32;
typedef unsigned int    __be32;
typedef unsigned int __u32;

typedef int __s32;
typedef unsigned short __u16;
typedef short __s16;
typedef unsigned char __u8;


//typedef unsigned long    __le64;

//typedef unsigned long    size_t


#define	ENOMEM		12	/* Out of Memory */
#define	EINVAL		22	/* Invalid argument */
#define ENOSPC		28	/* No space left on device */
#define ENOTSUPP	524	/* Operation is not supported */
#define  EOPNOTSUPP  95  /* Operation not supported on transport endpoint */
#define  ETIMEDOUT  110  /* Connection timed out */

//--------------------------------------------------------------------
// Globals
//--------------------------------------------------------------------


//--------------------------------------------------------------------
//  function types
//--------------------------------------------------------------------
// define AT command function type


#endif // _KERNEL_H_
