/*
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 * 
 * Author: Dirk Ziegelmeier <dziegel@gmx.de>
 *
 */

#ifndef MQTT_EXAMPLE_H
#define MQTT_EXAMPLE_H

#ifdef __cplusplus
extern "C" {
#endif

u8_t* CA_CERTIFICATE_PEM = NULL;
#if 1
u8_t* mqtt_cli_crt_pem = NULL;
size_t mqtt_cli_crt_pem_len = 0;

u8_t* mqtt_cli_key_rsa = NULL;
size_t mqtt_cli_key_rsa_len = 0;
#endif
#if 1
#if 0
static const u8_t CA_CERTIFICATE_PEM1[] = 
"-----BEGIN CERTIFICATE-----\n"
"MIIC6jCCAdICCQC7b9M3mK7V7jANBgkqhkiG9w0BAQ0FADA3MTUwMwYDVQQKDCxN\n"
"UVRUIFRMUyBQcm9qZWN0IERvZGd5IENlcnRpZmljYXRlIEF1dGhvcml0eTAeFw0y\n"
"MzEwMTgxMDE5MjJaFw0zMzEwMTUxMDE5MjJaMDcxNTAzBgNVBAoMLE1RVFQgVExT\n"
"IFByb2plY3QgRG9kZ3kgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MIIBIjANBgkqhkiG\n"
"9w0BAQEFAAOCAQ8AMIIBCgKCAQEAq7+tY1LwEwxaQQsb8FP92BtH1V+bkq42rWTm\n"
"mWFe9Tn/APaXWsggwZV+aEOvAUM2TjUQIGrTFaDC73RkJ+BRtxhIFUjdGwULPfJq\n"
"0Yt29t1mGOV8B8A+S9iPW0DQmisYsoNrgrsUiTF/U8lgydrehoxLtBu7/O2yoWLB\n"
"DCQauu07Pr3+JIhxeAYb/kljrIhIfHmV7zYyZpRRdyo42qulhGSjZmY/fEkJIBid\n"
"vAaP52/t6xVmRb7tysOgTvvToEvRPrPOR/mIoyUAIeE8Xks5EvirS569f6/Jzzdk\n"
"RjwCx6BP6sg6oAzzSB5QzJ9zrdugBLkiNBfD/RLcblCjn3GDpQIDAQABMA0GCSqG\n"
"SIb3DQEBDQUAA4IBAQClhpwY40yxgcL9Qp/jENs0GkNl4KV3ov/CKZpjTd0eTrxY\n"
"i32okZ/rms2hMEqSz3XBt3pauiH8EizuOMbn6D1u9Ml0ZAdv9v5oI8c07Tf+V0aM\n"
"heSJRVlL7DuywSFPi+fDeReL7x+jWZLxIuM5hwezQAPKrrYiSfFyaUVkwAlmjkZU\n"
"aGBu/l50CFnBTxAuNnOywt3kzVOXHxNvs1Ktx+Y0q93xTQ3Mv7Jkpl1zWC1rA92p\n"
"jWWOd2r3cl0vXWqp8FhqiQyckeX5//RDnAhEaLM435u1P9fJqRHJ6nughQdvWPYm\n"
"r5faTFDqxraDc0MAtkRHhfmgwO1WNUd5YxqPzR/c\n"
"-----END CERTIFICATE-----\n";
#endif
#if 0
static const u8_t CA_CERTIFICATE_PEM2[] = 
"-----BEGIN CERTIFICATE-----\n"
"MIIEAzCCAuugAwIBAgIUBY1hlCGvdj4NhBXkZ/uLUZNILAwwDQYJKoZIhvcNAQEL\n"
"BQAwgZAxCzAJBgNVBAYTAkdCMRcwFQYDVQQIDA5Vbml0ZWQgS2luZ2RvbTEOMAwG\n"
"A1UEBwwFRGVyYnkxEjAQBgNVBAoMCU1vc3F1aXR0bzELMAkGA1UECwwCQ0ExFjAU\n"
"BgNVBAMMDW1vc3F1aXR0by5vcmcxHzAdBgkqhkiG9w0BCQEWEHJvZ2VyQGF0Y2hv\n"
"by5vcmcwHhcNMjAwNjA5MTEwNjM5WhcNMzAwNjA3MTEwNjM5WjCBkDELMAkGA1UE\n"
"BhMCR0IxFzAVBgNVBAgMDlVuaXRlZCBLaW5nZG9tMQ4wDAYDVQQHDAVEZXJieTES\n"
"MBAGA1UECgwJTW9zcXVpdHRvMQswCQYDVQQLDAJDQTEWMBQGA1UEAwwNbW9zcXVp\n"
"dHRvLm9yZzEfMB0GCSqGSIb3DQEJARYQcm9nZXJAYXRjaG9vLm9yZzCCASIwDQYJ\n"
"KoZIhvcNAQEBBQADggEPADCCAQoCggEBAME0HKmIzfTOwkKLT3THHe+ObdizamPg\n"
"UZmD64Tf3zJdNeYGYn4CEXbyP6fy3tWc8S2boW6dzrH8SdFf9uo320GJA9B7U1FW\n"
"Te3xda/Lm3JFfaHjkWw7jBwcauQZjpGINHapHRlpiCZsquAthOgxW9SgDgYlGzEA\n"
"s06pkEFiMw+qDfLo/sxFKB6vQlFekMeCymjLCbNwPJyqyhFmPWwio/PDMruBTzPH\n"
"3cioBnrJWKXc3OjXdLGFJOfj7pP0j/dr2LH72eSvv3PQQFl90CZPFhrCUcRHSSxo\n"
"E6yjGOdnz7f6PveLIB574kQORwt8ePn0yidrTC1ictikED3nHYhMUOUCAwEAAaNT\n"
"MFEwHQYDVR0OBBYEFPVV6xBUFPiGKDyo5V3+Hbh4N9YSMB8GA1UdIwQYMBaAFPVV\n"
"6xBUFPiGKDyo5V3+Hbh4N9YSMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL\n"
"BQADggEBAGa9kS21N70ThM6/Hj9D7mbVxKLBjVWe2TPsGfbl3rEDfZ+OKRZ2j6AC\n"
"6r7jb4TZO3dzF2p6dgbrlU71Y/4K0TdzIjRj3cQ3KSm41JvUQ0hZ/c04iGDg/xWf\n"
"+pp58nfPAYwuerruPNWmlStWAXf0UTqRtg4hQDWBuUFDJTuWuuBvEXudz74eh/wK\n"
"sMwfu1HFvjy5Z0iMDU8PUDepjVolOCue9ashlS4EB5IECdSR2TItnAIiIwimx839\n"
"LdUdRudafMu5T5Xma182OC0/u/xRlEm+tvKGGmfFcN0piqVl8OrSPBgIlb+1IKJE\n"
"m/XriWr/Cq4h/JfB7NTsezVslgkBaoU=\n"
"-----END CERTIFICATE-----\n";
static const u8_t mqtt_cli_crt_pem[] = 
"-----BEGIN CERTIFICATE-----\n"
"MIIDbDCCAlSgAwIBAgIBADANBgkqhkiG9w0BAQsFADCBkDELMAkGA1UEBhMCR0Ix\n"
"FzAVBgNVBAgMDlVuaXRlZCBLaW5nZG9tMQ4wDAYDVQQHDAVEZXJieTESMBAGA1UE\n"
"CgwJTW9zcXVpdHRvMQswCQYDVQQLDAJDQTEWMBQGA1UEAwwNbW9zcXVpdHRvLm9y\n"
"ZzEfMB0GCSqGSIb3DQEJARYQcm9nZXJAYXRjaG9vLm9yZzAeFw0yNDEwMzEwNTU1\n"
"MjlaFw0yNTAxMjkwNTU1MjlaMEYxCzAJBgNVBAYTAklOMRAwDgYDVQQIDAdNeVN0\n"
"YXRlMRIwEAYDVQQKDAlNeUNvbXBhbnkxETAPBgNVBAMMCE15U2VydmVyMIIBIjAN\n"
"BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoi/yu+V8x8i2y1hMuoO8ZZvP25/k\n"
"inNCeKpXa58FYNtkRJy47sjBYL6cuAbO9qSlyzF7PqKK5JURhB8BwBwJ/gNmRzD4\n"
"kDfooR8O9w/Wo2rFY0Df7ezyoB7KWj+RnqlTmfjXWevHO/y0esVjkNqGa/bJDL6K\n"
"G+eTxtSbPtuUWj1IfivTDQbtfv4qd3c0MelkWxQ9QPABcaNYkIG6mAzvOonHc6RB\n"
"icm9BqOc4lmNJxCV/4tKJu0foFnJpyfdRE9PdtPr4JUvuk/nAXme8INT1InfKhSE\n"
"lfwr+my4RGy57jeb7MELuVOuU/SQeYmNdsnlVqrPeK7Ezqpgu5bdoTlopQIDAQAB\n"
"oxowGDAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DANBgkqhkiG9w0BAQsFAAOCAQEA\n"
"j5Z3czBczDyFB313ML64j3YdCstwT/vbqTRpnGM2JQ9qg4sAkZcgOk7J624Rv2yx\n"
"yrMq6mIGRlsq1UqEB3FMAqE3gq55abc5dI7SthuOuJ4So3U9cDYjtum4mzZvTF7s\n"
"mokRypbzzvSJ2wkhBNjNq12jeiysxEjK8xC7Nb+r4NLRS9bszrrdQEqZ2H4JjmpC\n"
"6yMAgrwszPMrpX8bf3yf5ge0Cn8S2F86tZwYGVWlS58NjGYYDSVCogBQ2F+FuOQ/\n"
"jJPDMp0VXKdsiI/zWP0Zz8wR1kVHfogWzxC4LTIBIaBqVy/iDCSMyvNuqTpIozRj\n"
"K2+mmwwlAXdceOrMp9+rVw==\n"
"-----END CERTIFICATE-----\n";
const size_t mqtt_cli_crt_pem_len = sizeof( mqtt_cli_crt_pem );

const char mqtt_cli_key_rsa[] =
"-----BEGIN RSA PRIVATE KEY-----\n"
"MIIEowIBAAKCAQEAoi/yu+V8x8i2y1hMuoO8ZZvP25/kinNCeKpXa58FYNtkRJy4\n"
"7sjBYL6cuAbO9qSlyzF7PqKK5JURhB8BwBwJ/gNmRzD4kDfooR8O9w/Wo2rFY0Df\n"
"7ezyoB7KWj+RnqlTmfjXWevHO/y0esVjkNqGa/bJDL6KG+eTxtSbPtuUWj1IfivT\n"
"DQbtfv4qd3c0MelkWxQ9QPABcaNYkIG6mAzvOonHc6RBicm9BqOc4lmNJxCV/4tK\n"
"Ju0foFnJpyfdRE9PdtPr4JUvuk/nAXme8INT1InfKhSElfwr+my4RGy57jeb7MEL\n"
"uVOuU/SQeYmNdsnlVqrPeK7Ezqpgu5bdoTlopQIDAQABAoIBACLI9d6m0aRnwAzM\n"
"22gFaRrB2EraeEHZhqAqqKVEbfrgExlEI8XS+Oau+x3dF/Z+SbDS5AQDCJcOAbu8\n"
"iruRR/Na90y9jBIia5pi9uq2Uuqps7wd5ek5sK/26p+AktLcrjmPzWBT2V9cS7kp\n"
"LLmcpMfzHhvFoglqGZ/DaaiJn7/anW8Amcb57hWtguJQk7Gpgu+OsbMtdeQv/f2N\n"
"eA8QupXki3RKmGdLjL4/3XLaY3pWREaGgVbjN9h88oZL1E6gcY5sxlagQI8fHvxf\n"
"PCWn9HwV4NI6Gr9JdN/EjYg7P72quaT1mp8kCX4EEnnxeLakzHkz+UzVVwyek9VN\n"
"NNe9RuECgYEA13Owon5/oPt2PMlRPl45ghxH+Wh7R8SUQLpnVlL/erO4kD7m5RM6\n"
"yUKctsqkqnjIEbX+ENSJnvvXP9ey/JHXPcEKhSV0eoMGSCbin4evQol3AMwAbSYP\n"
"xF8JQ9+etRLMAZGRWbicr2AUfsk7K1zCwoSCNtPbGKkEWRohaED1igsCgYEAwLYC\n"
"Y0ThiuG8Ob2HnhKufRunYRkEg7xldIxQfa9mvbHQwQaWX30LBH0hpAoov+rdKLLY\n"
"Hh90kqRsMN9ePxFhe12Far+rk9yFP1rXPkOZdLwYm3zqCdyKj/HDqvH6BZGmVXHI\n"
"sOV+KQX8ni60U6zLxzXPrAH0rSGcslLn8SIoNg8CgYABKezQU+KYmgMffO7laVji\n"
"LQjuffP8hUFPwDICs1wR65qZnN1ea2Yr5CI4koulKBXckqEWsi80HqQhAidDWf5R\n"
"pRNLeNJSPxbvmNYsim0V7OwpovB1pnj7VJAWP8T5sWpMr96bH3YpNFmn/apGJ7Ad\n"
"oN2bMjXCwlb1rEB18bPh1QKBgQCafM6pOfz9Uz2LpE7l/9/114d1JZMi8JL8vceB\n"
"Gm3owHWzaE6AOkPs00t2r9Y/FE87YzQx4dGYBUveWhK5yHs3ZJ+iFgm8PVpskaxf\n"
"890/YdLwQ1FzmmNSReQwVE+0yzBm6xKSDUf4Jx5+yL4zHiE2kALtx5uYd4ugwSnD\n"
"ezh1LQKBgFx82qW6wpkaOckoNZIqWKMhirU/ZtjrNdRS0WjTHG8vFSDDzAokOiuP\n"
"4BSONGMFhdNWckeq+6ZU+gcHM1u2K0Lye2nXLrfUqVRAprNdkfQ3x2/zQov1XRL0\n"
"x3ncjcfcEUxuimSvh6Mp94wDBgwRQoxDIo220VxGj+mzitai5wKU\n"
"-----END RSA PRIVATE KEY-----\n";
const size_t mqtt_cli_key_rsa_len = sizeof( mqtt_cli_key_rsa );
#endif
#else
static const u8_t CA_CERTIFICATE_PEM1[] = 
"-----BEGIN CERTIFICATE-----\n"
"MIIEAzCCAuugAwIBAgIUBY1hlCGvdj4NhBXkZ/uLUZNILAwwDQYJKoZIhvcNAQEL\n"
"BQAwgZAxCzAJBgNVBAYTAkdCMRcwFQYDVQQIDA5Vbml0ZWQgS2luZ2RvbTEOMAwG\n"
"A1UEBwwFRGVyYnkxEjAQBgNVBAoMCU1vc3F1aXR0bzELMAkGA1UECwwCQ0ExFjAU\n"
"BgNVBAMMDW1vc3F1aXR0by5vcmcxHzAdBgkqhkiG9w0BCQEWEHJvZ2VyQGF0Y2hv\n"
"by5vcmcwHhcNMjAwNjA5MTEwNjM5WhcNMzAwNjA3MTEwNjM5WjCBkDELMAkGA1UE\n"
"BhMCR0IxFzAVBgNVBAgMDlVuaXRlZCBLaW5nZG9tMQ4wDAYDVQQHDAVEZXJieTES\n"
"MBAGA1UECgwJTW9zcXVpdHRvMQswCQYDVQQLDAJDQTEWMBQGA1UEAwwNbW9zcXVp\n"
"dHRvLm9yZzEfMB0GCSqGSIb3DQEJARYQcm9nZXJAYXRjaG9vLm9yZzCCASIwDQYJ\n"
"KoZIhvcNAQEBBQADggEPADCCAQoCggEBAME0HKmIzfTOwkKLT3THHe+ObdizamPg\n"
"UZmD64Tf3zJdNeYGYn4CEXbyP6fy3tWc8S2boW6dzrH8SdFf9uo320GJA9B7U1FW\n"
"Te3xda/Lm3JFfaHjkWw7jBwcauQZjpGINHapHRlpiCZsquAthOgxW9SgDgYlGzEA\n"
"s06pkEFiMw+qDfLo/sxFKB6vQlFekMeCymjLCbNwPJyqyhFmPWwio/PDMruBTzPH\n"
"3cioBnrJWKXc3OjXdLGFJOfj7pP0j/dr2LH72eSvv3PQQFl90CZPFhrCUcRHSSxo\n"
"E6yjGOdnz7f6PveLIB574kQORwt8ePn0yidrTC1ictikED3nHYhMUOUCAwEAAaNT\n"
"MFEwHQYDVR0OBBYEFPVV6xBUFPiGKDyo5V3+Hbh4N9YSMB8GA1UdIwQYMBaAFPVV\n"
"6xBUFPiGKDyo5V3+Hbh4N9YSMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL\n"
"BQADggEBAGa9kS21N70ThM6/Hj9D7mbVxKLBjVWe2TPsGfbl3rEDfZ+OKRZ2j6AC\n"
"6r7jb4TZO3dzF2p6dgbrlU71Y/4K0TdzIjRj3cQ3KSm41JvUQ0hZ/c04iGDg/xWf\n"
"+pp58nfPAYwuerruPNWmlStWAXf0UTqRtg4hQDWBuUFDJTuWuuBvEXudz74eh/wK\n"
"sMwfu1HFvjy5Z0iMDU8PUDepjVolOCue9ashlS4EB5IECdSR2TItnAIiIwimx839\n"
"LdUdRudafMu5T5Xma182OC0/u/xRlEm+tvKGGmfFcN0piqVl8OrSPBgIlb+1IKJE\n"
"m/XriWr/Cq4h/JfB7NTsezVslgkBaoU=\n"
"-----END CERTIFICATE-----\n";
#endif
#if 0
static const u8_t mqtt_cli_crt_pem[] = 
"-----BEGIN CERTIFICATE-----\n"
"MIIDbDCCAlSgAwIBAgIBADANBgkqhkiG9w0BAQsFADCBkDELMAkGA1UEBhMCR0Ix\n"
"FzAVBgNVBAgMDlVuaXRlZCBLaW5nZG9tMQ4wDAYDVQQHDAVEZXJieTESMBAGA1UE\n"
"CgwJTW9zcXVpdHRvMQswCQYDVQQLDAJDQTEWMBQGA1UEAwwNbW9zcXVpdHRvLm9y\n"
"ZzEfMB0GCSqGSIb3DQEJARYQcm9nZXJAYXRjaG9vLm9yZzAeFw0yNDA2MDMwNTE4\n"
"MjlaFw0yNDA5MDEwNTE4MjlaMEYxCzAJBgNVBAYTAklOMRAwDgYDVQQIDAdNeVN0\n"
"YXRlMRIwEAYDVQQKDAlNeUNvbXBhbnkxETAPBgNVBAMMCE15U2VydmVyMIIBIjAN\n"
"BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy6moiaZ0xXE3t3mkg+tTYDjrUDzT\n"
"q33ypuGtpnMHOuJIOUxdR8yKr1kPcxMSGgM6XRl3mMTYku9eVQu86EZTD7DQ0g8n\n"
"Ea9U5DQiJYxpSs/dMZpSYcdxg1lkVCjvBQbD7ReM4Nhy6mwxZnh8KNlnncQspyRo\n"
"CtCn2R0nTsS8OWdIR2U13hFwHOCPph6xJXRv1JB1GOQqeqpoqt/Fvj+X60Axpryd\n"
"B3ZUpXvUna3EAyc8RyXeOH+mZCDkg5OOOFbt4x/1H7HAWnfHPn61kuEhbO5eAzVC\n"
"mg/fJze85MYJ1k0oga782YdsLPKzDXPScQAKpCyaYfvS/+pYoo63GHKa+QIDAQAB\n"
"oxowGDAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DANBgkqhkiG9w0BAQsFAAOCAQEA\n"
"tmhb8ON3I7KZ0SSkOo6F1j8vkdsgMGlFh8M04n29y/G5Pj5Geq55YcW76+zubB0J\n"
"F4YfYZjP4vO/vhRzb7TZgTgFld/vcOv9B3rwIt2RPlamS0vzVuvxgmEE//Qt/78d\n"
"RNuVanKVrWYpESI1hbd6wWHNspkZLrCc9BOXMC1EydiLeuplYCvUlqsO94si24Od\n"
"SJWrEPi4VPd9L1+hk51yaTkJiQxVrMfMxlSIIxDcFJs1SJwzM+o/oi81jdkeniv7\n"
"mRSR/TnsbeqjkoLQGqlhFfsJku7HdoXfBzzh0mB/HcqAN2mmIrpe/aKq6zCjHqPh\n"
"KY2XeN95sHfjb/BKT5wK/g==\n"
"-----END CERTIFICATE-----\n";
const size_t mqtt_cli_crt_pem_len = sizeof( mqtt_cli_crt_pem );

const char mqtt_cli_key_rsa[] =
"-----BEGIN RSA PRIVATE KEY-----\n"
"MIIEowIBAAKCAQEAy6moiaZ0xXE3t3mkg+tTYDjrUDzTq33ypuGtpnMHOuJIOUxd\n"
"R8yKr1kPcxMSGgM6XRl3mMTYku9eVQu86EZTD7DQ0g8nEa9U5DQiJYxpSs/dMZpS\n"
"Ycdxg1lkVCjvBQbD7ReM4Nhy6mwxZnh8KNlnncQspyRoCtCn2R0nTsS8OWdIR2U1\n"
"3hFwHOCPph6xJXRv1JB1GOQqeqpoqt/Fvj+X60AxprydB3ZUpXvUna3EAyc8RyXe\n"
"OH+mZCDkg5OOOFbt4x/1H7HAWnfHPn61kuEhbO5eAzVCmg/fJze85MYJ1k0oga78\n"
"2YdsLPKzDXPScQAKpCyaYfvS/+pYoo63GHKa+QIDAQABAoIBAHSwur5Tv2g5XIEl\n"
"k1t6hAUH19vbXjROL6/qcoKCOcxFRrh9xpyS14tsbeuzK5X374LUSrAfaS+XMudr\n"
"mEtFr+W3m44f3HTHjs5KCJ6W+uVAgC4hi742dhWaLGAELB8nJy87ZR6XJhCm+Q8L\n"
"TahiGHpOon8J3wsDToiZqaH6GxaPzxmsiSEm8Da/AgK7S57iN7Xqd98XhyNEwh7h\n"
"h4CKL7GNstU1qwbjmkx0CMR+ARoiDIVT3dbdkiKV4b/d5HuWK+FHLh0Xq7NNnJJB\n"
"PHP+NNvwAd5V40Dm8uTnjmpQMQ92kS60u+eZyKE+8bXtP57hUwP5HIfaf3xkxE9l\n"
"aYcUNNkCgYEA6r4yry6+qmK7bD1QWRpkHcPcRW/xSpwvwe7m/yqYFaHhtIWvo4kc\n"
"rizWMc0b4MBveRJVUGOi6ajxo4pHbzOACiflV3aqXS8N+n290QzA9cqGADZWdsgQ\n"
"nXt4iK9nIci3HkzIcNScIBN0Pz+MRl1+ckaNOmyyurteDCcOAkzL6a8CgYEA3hr1\n"
"qr0DNy/4w63Dg+SErc045gh7D5KyFRYFTcTTJ0mQawdwwUkgviC9KXVRc2WaMnI2\n"
"C9C4n+DNyZYMrKaaN37w05ldELYPaco3tF6stz5mzLhL6E/4jKbO0iG35MvvdG3v\n"
"3oXzYZ9aaHsv5fxK8jnlyIh/TI1wmdjg0Gq/d9cCgYBFTD7ELoWE4T65FmSo2Tyi\n"
"+NYG/aP6xZ7nnnI888MP58kstKaEHY8E8CGPdCB9ufFuiXX8FF3cos4q3EB4WHi9\n"
"BsgSiOqENcbnosUteJliNhZW67OcvzUAeJm9qCJG++zrGfm2LV2lrniLz2PGxgT1\n"
"EVTR4ZLlwzhhWAovraIo6wKBgQCMjj8dt9PLHv6sxtBOLVWRr6fsWz2Vk15DXdYp\n"
"av+9gx5zvResGh0wdQOAsw/CmW/FsOVnAMV12AwjIGQQ9rXtnNXG8u0kYDLM3f32\n"
"lVtz83eW4qKW99TxHbcQ3+nCTxTQd6ovBlIJW5EZQawEPW8ob19tUoRM681wbwGG\n"
"o6dbrQKBgHOrGBr3wHwtfQRzLtDQpuT7wZT+CFUZUMzPQ6K9x1HTJTBI/VxML1b0\n"
"feqxMbYLxd9GLHCJb0SLeaONTJ9wKD/RTWyE7B4vKrXPTRXPxC6W79DNCMFg5zw5\n"
"roJIsLeAlXNGswzbCUv417Sbhz2A2YBgJ725DMEQbV7WCz3mGfUT\n"
"-----END RSA PRIVATE KEY-----\n";
const size_t mqtt_cli_key_rsa_len = sizeof( mqtt_cli_key_rsa );
#endif

void mqtt_example_init(uint8_t type);

#ifdef __cplusplus
}
#endif

#endif /* MQTT_EXAMPLE_H */
