#ifndef _PACKET_H
#define _PACKET_H

#include "lwip/udp.h"
#include "lwip/ip.h"
#include "lwip/icmp.h"

/* IP options */
#define IPVERSION	4
#define MAXTTL		255
#define IPDEFTTL	64

struct dhcpMessage {
	u8 op;
	u8 htype;
	u8 hlen;
	u8 hops;
	u32 xid;
	u16 secs;
	u16 flags;
	u32 ciaddr;
	u32 yiaddr;
	u32 siaddr;
	u32 giaddr;
	u8 chaddr[16];
	u8 sname[64];
	u8 file[128];
	u32 cookie;
	u8 options[308]; /* 312 - cookie */ 
};



struct icmp_packet {
	struct ip_hdr ip;
	struct icmp_echo_hdr icmp;
};

struct udp_dhcp_packet {
	struct ip_hdr ip;
	struct udp_hdr udp;
	struct dhcpMessage data;
};


struct udp_dhcp_eth_packet {
	u8 eth[14];
	struct udp_dhcp_packet dhcp;
};


void init_header(struct dhcpMessage *packet, char type);
int get_packet(struct dhcpMessage *packet, int fd);
u16 checksum(void *addr, int count);
int raw_packet(struct dhcpMessage *payload, u32 source_ip, int source_port,
		   u32 dest_ip, int dest_port, unsigned char *dest_arp, int ifindex);
int kernel_packet(struct dhcpMessage *payload, u32 source_ip, int source_port,
		   u32 dest_ip, int dest_port);


#endif
