/* leases.h */
#ifndef _LEASES_H
#define _LEASES_H


struct dhcpOfferedAddr {
	u8 chaddr[16];
	u32 yiaddr;	/* network order */
	u32 expires;	/* host order */
};

extern unsigned char blank_chaddr[];

void clear_lease(u8 *chaddr, u32 yiaddr);
struct dhcpOfferedAddr *add_lease(u8 *chaddr, u32 yiaddr, unsigned long lease);
int lease_expired(struct dhcpOfferedAddr *lease);
struct dhcpOfferedAddr *oldest_expired_lease(void);
struct dhcpOfferedAddr *find_lease_by_chaddr(u8 *chaddr);
struct dhcpOfferedAddr *find_lease_by_yiaddr(u32 yiaddr);
u32 find_address(int check_expired);
int check_ip(u32 addr);


#endif
