/*
 * arpping .h
 */

#ifndef ARPPING_H
#define ARPPING_H

struct arpMsg {
	//struct ethhdr ethhdr;	 		/* Ethernet header */
	u16 htype;				/* hardware type (must be ARPHRD_ETHER) */
	u16 ptype;				/* protocol type (must be ETH_P_IP) */
	u8  hlen;				/* hardware address length (must be 6) */
	u8  plen;				/* protocol address length (must be 4) */
	u16 operation;			/* ARP opcode */
	u8  sHaddr[6];			/* sender's hardware address */
	u8  sInaddr[4];			/* sender's IP address */
	u8  tHaddr[6];			/* target's hardware address */
	u8  tInaddr[4];			/* target's IP address */
	u8  pad[18];			/* pad for min. Ethernet payload (60 bytes) */
};

/* function prototypes */
int arpping(u32 yiaddr, u32 ip, u8 *arp, char *interface);

#endif
