/*
 * WSM host interface (HI) interface for ST-Ericsson CW1200 mac80211 drivers
 *
 * Copyright (c) 2010, ST-Ericsson
 * Author: Dmitry Tarnyagin <dmitry.tarnyagin@stericsson.com>
 *
 * Based on CW1200 UMAC WSM API, which is
 * Copyright (C) ST-Ericsson SA 2010
 * Author: Stewart Mathers <stewart.mathers@stericsson.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef CW1200_WSM_COMMON_H_INCLUDED
#define CW1200_WSM_COMMON_H_INCLUDED

enum app_running_status {	//Will.Zhang
	APP_RUNNING_STA=0,
	APP_RUNNING_AP,
	APP_RUNNING_AP_STA,
	APP_RUNNING_MP,
	APP_RUNNING_AP_MP,
};

#define IEEE80211_FCTL_FTYPE		0x000c
#define IEEE80211_STYPE_QOS_DATA		0x0080
#define IEEE80211_FTYPE_DATA		0x0008

static inline int ieee80211_is_data_qos_common(unsigned short fc)
{
	/*
	 * mask with QOS_DATA rather than IEEE80211_FCTL_STYPE as we just need
	 * to check the one bit
	 */
	return (fc & (unsigned short)(IEEE80211_FCTL_FTYPE | IEEE80211_STYPE_QOS_DATA)) ==
	       (unsigned short)(IEEE80211_FTYPE_DATA | IEEE80211_STYPE_QOS_DATA);
}
#endif /* CW1200_HWIO_H_INCLUDED */
