/*
 * Datapath interface for ST-Ericsson CW1200 mac80211 drivers
 *
 * Copyright (c) 2010, ST-Ericsson
 * Author: Dmitry Tarnyagin <dmitry.tarnyagin@stericsson.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef CW1200_TXRX_H
#define CW1200_TXRX_H
//tom start
#include "mac80211.h"
#include "ap.h"
#include "wsm.h"

#define BIT(nr)			(1UL << (nr))
//tom end
/* extern */ struct ieee80211_hw;
/* extern */ struct sk_buff;
/* extern */ struct wsm_tx;
/* extern */ struct wsm_rx;
/* extern */ struct wsm_tx_confirm;
/* extern */ struct cw1200_txpriv;
/* extern */ struct cw1200_vif;

struct tx_policy {
	union {
		__le32 tbl[3];
		u8 raw[12];
	};
	u8  defined;		/* TODO: u32 or u8, profile and select best */
	u8  usage_count;	/* --// -- */
	u8  retry_count;	/* --// -- */
	u8  uploaded;
};

struct tx_policy_cache_entry {
	struct tx_policy policy;
	//struct list_head link;	//michael confirm ?delete
};

#define TX_POLICY_CACHE_SIZE	(8)
struct tx_policy_cache {
	struct tx_policy_cache_entry cache[TX_POLICY_CACHE_SIZE];
	//struct list_head used;	//michael confirm ?delete
	//struct list_head free;
	//spinlock_t lock;
};

/* ******************************************************************** */
/* TX policy cache							*/
/* Intention of TX policy cache is an overcomplicated WSM API.
 * Device does not accept per-PDU tx retry sequence.
 * It uses "tx retry policy id" instead, so driver code has to sync
 * linux tx retry sequences with a retry policy table in the device.
 */
void tx_policy_init(struct cw1200_common *hw_priv);
void tx_policy_upload_work(struct cw1200_common *hw_priv);

/* ******************************************************************** */
/* TX implementation							*/

u32 cw1200_rate_mask_to_wsm(struct cw1200_common *hw_priv,
			       u32 rates);
void cw1200_tx(struct ieee80211_hw *dev, struct sk_buff *skb);
void cw1200_skb_dtor(struct cw1200_common *hw_priv,
		     struct sk_buff *skb,
		     const struct cw1200_txpriv *txpriv);

/* ******************************************************************** */
/* WSM callbacks							*/

void cw1200_tx_confirm_cb(struct cw1200_common *hw_priv,
			  struct wsm_tx_confirm *arg);
void cw1200_rx_cb(struct cw1200_vif *priv,
		  struct wsm_rx *arg,
		  struct sk_buff **skb_p);

/* ******************************************************************** */
/* Timeout								*/

void cw1200_tx_timeout(struct work_struct *work);

/* ******************************************************************** */
/* Security								*/
int cw1200_alloc_key(struct cw1200_common *hw_priv);
void cw1200_free_key(struct cw1200_common *hw_priv, int idx);
void cw1200_free_keys(struct cw1200_common *hw_priv);
int cw1200_upload_keys(struct cw1200_vif *priv);

/* ******************************************************************** */
/* Workaround for WFD test case 6.1.10					*/
#if defined(CONFIG_CW1200_USE_STE_EXTENSIONS)
void cw1200_link_id_reset(struct work_struct *work);
#endif

#endif /* CW1200_TXRX_H */
