/*
 * Mac80211 STA interface for ST-Ericsson CW1200 mac80211 drivers
 *
 * Copyright (c) 2010, ST-Ericsson
 * Author: Dmitry Tarnyagin <dmitry.tarnyagin@stericsson.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef STA_H_INCLUDED
#define STA_H_INCLUDED

//tom start
//#include "stm32f4xx_lib.h"
/* ******************************************************************** */
/* mac80211 API								*/
#include "mac80211.h"
#include "cw1200_main.h"


struct arphdr
{
	unsigned short		ar_hrd;		/* format of hardware address	*/
	unsigned short		ar_pro;		/* format of protocol address	*/
	unsigned char	ar_hln;		/* length of hardware address	*/
	unsigned char	ar_pln;		/* length of protocol address	*/
	unsigned short		ar_op;		/* ARP opcode (command)		*/

#if 0
	 /*
	  *	 Ethernet looks like this : This bit is variable sized however...
	  */
	unsigned char		ar_sha[ETH_ALEN];	/* sender hardware address	*/
	unsigned char		ar_sip[4];		/* sender IP address		*/
	unsigned char		ar_tha[ETH_ALEN];	/* target hardware address	*/
	unsigned char		ar_tip[4];		/* target IP address		*/
#endif

};
//tom end
int cw1200_start(struct ieee80211_hw *dev);
void cw1200_stop(struct ieee80211_hw *dev);
int cw1200_add_interface(struct ieee80211_hw *dev,
			 struct ieee80211_vif *vif);
void cw1200_remove_interface(struct ieee80211_hw *dev,
			     struct ieee80211_vif *vif);
int cw1200_change_interface(struct ieee80211_hw *dev,
				struct ieee80211_vif *vif,
				enum nl80211_iftype new_type,
				bool p2p);

int cw1200_config(struct ieee80211_hw *dev, u32 changed);
int cw1200_change_interface(struct ieee80211_hw *dev,
                                struct ieee80211_vif *vif,
                                enum nl80211_iftype new_type,
                                bool p2p);
void cw1200_configure_filter(struct ieee80211_hw *dev,
			     struct ieee80211_vif *vif,
			     unsigned int changed_flags,
			     unsigned int *total_flags,
			     u64 multicast);
int cw1200_conf_tx(struct ieee80211_hw *dev, struct ieee80211_vif *vif,
		u16 queue, const struct ieee80211_tx_queue_params *params);
int cw1200_get_stats(struct ieee80211_hw *dev,
		     struct ieee80211_low_level_stats *stats);
/* Not more a part of interface?
int cw1200_get_tx_stats(struct ieee80211_hw *dev,
			struct ieee80211_tx_queue_stats *stats);
*/
int cw1200_set_key(struct ieee80211_hw *dev, enum set_key_cmd cmd,
		   struct ieee80211_vif *vif, struct ieee80211_sta *sta,
		   struct ieee80211_key_conf *key);

int cw1200_set_rts_threshold(struct ieee80211_hw *hw,
		struct ieee80211_vif *vif, u32 value);

void cw1200_flush(struct ieee80211_hw *hw,
		  struct ieee80211_vif *vif,
		  bool drop);

int cw1200_remain_on_channel(struct ieee80211_hw *hw,
				struct ieee80211_vif *vif,
				struct ieee80211_channel *chan,
				enum nl80211_channel_type channel_type,
				int duration, u64 cookie);

int cw1200_cancel_remain_on_channel(struct ieee80211_hw *hw);

int cw1200_set_arpreply(struct ieee80211_hw *hw, struct ieee80211_vif *vif);

u64 cw1200_prepare_multicast(struct ieee80211_hw *hw,
			     struct ieee80211_vif *vif,
			     struct netdev_hw_addr_list *mc_list);

int cw1200_set_pm(struct cw1200_vif *priv, const struct wsm_set_pm *arg);

void cw1200_set_data_filter(struct ieee80211_hw *hw,
			   struct ieee80211_vif *vif,
			   void *data,
			   int len);
/* ******************************************************************** */
/* WSM callbacks							*/

/* void cw1200_set_pm_complete_cb(struct cw1200_common *hw_priv,
	struct wsm_set_pm_complete *arg); */
void cw1200_channel_switch_cb(struct cw1200_common *hw_priv);

/* ******************************************************************** */
/* WSM events								*/

void cw1200_free_event_queue(struct cw1200_common *hw_priv);
void cw1200_event_handler(struct work_struct *work);
void cw1200_bss_loss_work(struct work_struct *work);
void cw1200_connection_loss_work(struct work_struct *work);
void cw1200_keep_alive_work(struct work_struct *work);
void cw1200_tx_failure_work(struct work_struct *work);

/* ******************************************************************** */
/* Internal API								*/

int cw1200_setup_mac(struct cw1200_common *hw_priv);
void cw1200_join_work(struct cw1200_common *hw_priv);
void cw1200_join_timeout(struct work_struct *work);
void cw1200_unjoin_work( struct cw1200_common *hw_priv );
void cw1200_offchannel_work(struct work_struct *work);
void cw1200_wep_key_work(struct work_struct *work);
void cw1200_update_filtering(struct cw1200_vif *priv);
void cw1200_update_filtering_work(struct cw1200_common *hw_priv);
int __cw1200_flush(struct cw1200_common *hw_priv, bool drop, int if_id);
void cw1200_set_beacon_wakeup_period_work(struct cw1200_common *hw_priv);
int cw1200_enable_listening(struct cw1200_vif *priv,
			struct ieee80211_channel *chan);
int cw1200_disable_listening(struct cw1200_vif *priv);
int cw1200_set_uapsd_param(struct cw1200_vif *priv,
				const struct wsm_edca_params *arg);
void cw1200_ba_work(struct work_struct *work);
void cw1200_ba_timer(unsigned long arg);
const u8 *cw1200_get_ie(u8 *start, size_t len, u8 ie);
int cw1200_vif_setup(struct cw1200_vif *priv);
int cw1200_setup_mac_pvif(struct cw1200_vif *priv);
void cw1200_iterate_vifs(void *data, u8 *mac,
			 struct ieee80211_vif *vif);
void cw1200_rem_chan_timeout();
int cw1200_set_macaddrfilter(struct cw1200_common *hw_priv, struct cw1200_vif *priv, u8 *data);
#ifdef IPV6_FILTERING
int cw1200_set_na(struct ieee80211_hw *hw,
			struct ieee80211_vif *vif);
#endif /*IPV6_FILTERING*/



int cw1200_set_udp_filter(struct ieee80211_hw *hw, unsigned long ulPort);
#endif
