
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __STM3210E_EVAL_SPI_FLASH_H
#define __STM3210E_EVAL_SPI_FLASH_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
//#include "stm32f4xx_gpio.h"
//#include "stm32f4xx_rcc.h"
#include "GKI_spi.h"
#include "GKI_DataTypes.h"
#define CW1200_SPI                       SPI0
#define CW1200_SPI_CLK                   RCC_APB2Periph_SPI1
#define CW1200_SPI_SCK_PIN               GPIO_Pin_5                  /* PA.05 */
#define CW1200_SPI_SCK_GPIO_PORT         GPIOA                       /* GPIOA */
#define CW1200_SPI_SCK_GPIO_CLK          RCC_AHB1Periph_GPIOA
#define CW1200_SPI_SCK_SOURCE            GPIO_PinSource5

#define CW1200_SPI_MISO_PIN              GPIO_Pin_6                  /* PA.06 */
#define CW1200_SPI_MISO_GPIO_PORT        GPIOA                       /* GPIOA */
#define CW1200_SPI_MISO_GPIO_CLK         RCC_AHB1Periph_GPIOA
#define CW1200_SPI_MISO_SOURCE           GPIO_PinSource6

#define CW1200_SPI_MOSI_PIN              GPIO_Pin_7                  /* PA.07 */
#define CW1200_SPI_MOSI_GPIO_PORT        GPIOA                       /* GPIOA */
#define CW1200_SPI_MOSI_GPIO_CLK         RCC_AHB1Periph_GPIOA
#define CW1200_SPI_MOSI_SOURCE           GPIO_PinSource7

#define CW1200_CS_PIN                    GPIO_Pin_4                  /* 1200 Pa.4 */
#define CW1200_CS_GPIO_PORT              GPIOA                       
#define CW1200_CS_GPIO_CLK               RCC_AHB1Periph_GPIOA
   /*
   
   void GPIO_SetBits(GPIO_TypeDef* GPIOx, GPIO_Pin pin)

void GPIO_ResetBits(GPIO_TypeDef* GPIOx, GPIO_Pin pin)
   */
#include "GKI_gpio.h"
   
   
#define CW1200_CS_LOW()      GKI_GPIO_PortReset(Port_3)// GKI_GPIO_ResetBits(GPIOA,Pin_3)
/**
  * @brief  Deselect CW1200: Chip Select pin high
  */
#define CW1200_CS_HIGH()     GKI_GPIO_PortSet(Port_3) //GKI_GPIO_SetBits(GPIOA,Pin_3)   
/**
  * @}
  */ 
struct spi_message {
	
	void			(*complete)(void *context);
	void			*context;
	unsigned		actual_length;
	int			status;

	/* for optional use by whatever driver currently owns the
	 * spi_message ...  between calls to spi_async and then later
	 * complete(), that's the spi_master controller driver.
	 */
	void			*state;
};
struct spi_transfer {
	/* it's ok if tx_buf == rx_buf (right?)
	 * for MicroWire, one buffer must be null
	 * buffers must work with dma_*map_single() calls, unless
	 *   spi_message.is_dma_mapped reports a pre-existing mapping
	 */
	const void	*tx_buf;
	void		*rx_buf;
	unsigned	len;

	unsigned	cs_change:1;
	u8		bits_per_word;
	u16		delay_usecs;
	u32		speed_hz;

};

struct spi_device {
	u32			max_speed_hz;
	u8			chip_select;
	u8			mode;
    
#define	SPI_CPHA_MODE	0x01			/* clock phase */
#define	SPI_CPOL_MODE	0x02			/* clock polarity */
#define	SPI_MODE_0	(0|0)			/* (original MicroWire) */
#define	SPI_MODE_1	(0|SPI_CPHA)
#define	SPI_MODE_2	(SPI_CPOL|0)
#define	SPI_MODE_3	(SPI_CPOL|SPI_CPHA)
#define	SPI_CS_HIGH	0x04			/* chipselect active high? */
#define	SPI_LSB_FIRST	0x08			/* per-word bits-on-wire */
#define	SPI_3WIRE	0x10			/* SI/SO signals shared */
#define	SPI_LOOP	0x20			/* loopback mode */
#define	SPI_NO_CS	0x40			/* 1 dev/bus, no chipselect */
#define	SPI_READY	0x80			/* slave pulls low to pause */
    
	u8			bits_per_word;
	int			irq;
	void			*controller_state;
	void			*controller_data;
	char			modalias[16];
	int			cs_gpio;	/* chip select gpio */

	/*
	 * likely need more hooks for more protocol options affecting how
	 * the controller talks to each chip, like:
	 *  - memory packing (12 bit samples into low bits, others zeroed)
	 *  - priority
	 *  - drop chipselect after each word
	 *  - chipselect delays
	 *  - ...
	 */
};

//CW1200 SPI control information.
extern SpiCtrlInfo_t xCW1200SpiCtrlInfo;

/**
  * @brief  High layer functions
  */
void CW1200_DeInit(void);
void CW1200_SpiInit(void);
void spi_interrupt_handler( void );

/**
  * @brief  Low layer functions
  */
u8 CW1200_ReadByte(void);
u16 CW1200_ReadHalfWord(void);
u8 CW1200_SendByte(u8 byte);
u16 CW1200_SendHalfWord(u16 HalfWord);

#ifdef __cplusplus
}
#endif

#endif /* __STM3210E_EVAL_SPI_FLASH_H */
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */ 

/**
  * @}
  */  

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
