#ifndef _CW1200_MAIN_H
#define _CW1200_MAIN_H
#include <string.h>

/* Hardware Abstraction Layer */
//#include "HAL_lib.h"

#include "sdio.h"

#include "mac80211.h"
#include "cfg80211.h"
#include "wsm.h"
#include "scan.h"
#include "bh.h"
#include "cwqueue.h"
#include "txrx.h"
#include "sta.h"
#include "ht.h"
#include "ieee80211_i.h"
#include "ser_dbg.h"
#include "fwio.h"
#include "tiny_fs.h"
//#include "flash.h"
#include "cw1200_spi.h"
//#include "pm.h"

#include "cw1200_common.h"
#include "workqueue.h"
//#define USE_PS_MODE
//#define HZ 1000 //tom here attention!!!!!!!!!!!for cw1200 queue.c
int ffs(int x);
#define CW12XX_GENERIC_IF_ID		(2)
#define CW12XX_HOST_VIF0_11N_THROTTLE	(63)
#define CW12XX_HOST_VIF1_11N_THROTTLE	(63)
#define CW12XX_HOST_VIF0_11BG_THROTTLE	(31)
#define CW12XX_HOST_VIF1_11BG_THROTTLE	(31)
#if 0
#define CW12XX_FW_VIF0_THROTTLE		(15)
#define CW12XX_FW_VIF1_THROTTLE		(15)
#endif
#define CW12XX_MAX_QUEUE_SZ		(128)

#define IEEE80211_FCTL_WEP      0x4000
#define IEEE80211_QOS_DATAGRP   0x0080
#define WSM_KEY_MAX_IDX		20

#define ETH_P_TDLS	0x890D          /* TDLS */


#define CW1200_DBG_MSG		0x00000001
#define CW1200_DBG_NIY		0x00000002
#define CW1200_DBG_SBUS		0x00000004
#define CW1200_DBG_INIT		0x00000008
#define CW1200_DBG_ERROR	0x00000010
#define CW1200_DBG_LEVEL	0xFFFFFFFF

#define CW1200_WSM_PACKET_ID        1
#define CW1200_WSM_MAX_TX_RATE      21
#define CW1200_WSM_QUEUE_ID         0
#define CW1200_WSM_MORE             0
#define CW1200_WSM_FLAGS            0x0A
#define CW1200_WSM_HT_TX_PARAMS     1

#define CW1200_CQM_LINK_LOSS_COUNT    40
#define CW1200_CQM_BEACON_LOSS_COUNT  20

#define cw1200_dbg(level, ...)				\
	do {                                            \
          if ((level) & CW1200_DBG_LEVEL)		\
			printu( __VA_ARGS__);	        \
	} while (0)

#define CW1200_MAX_CTRL_FRAME_LEN	(0x1000)

#define CW1250_MAX_STA_IN_AP_MODE	(14)
//#define CW1250_MAX_STA_IN_AP_MODE	(10)	//by cbq 2024.08.17

#define CW1200_MAX_STA_IN_AP_MODE	(5)
#define WLAN_LINK_ID_MAX		(CW1250_MAX_STA_IN_AP_MODE + 3)
#define CW1200_MAX_REQUEUE_ATTEMPTS	(5)
#define CW1200_LINK_ID_UNMAPPED		(15)

#define CW1200_MAX_TID			(8)
#define CW1200_TX_BLOCK_ACK_ENABLED_FOR_ALL_TID (0x3F)
#define CW1200_RX_BLOCK_ACK_ENABLED_FOR_ALL_TID (0x3F)
#define CW1200_RX_BLOCK_ACK_ENABLED_FOR_BE_TID \
	(CW1200_TX_BLOCK_ACK_ENABLED_FOR_ALL_TID & 0x01)
#define CW1200_TX_BLOCK_ACK_DISABLED_FOR_ALL_TID       (0)
#define CW1200_RX_BLOCK_ACK_DISABLED_FOR_ALL_TID       (0)

#define CW1200_BLOCK_ACK_CNT		(30)
#define CW1200_BLOCK_ACK_THLD		(800)
#define CW1200_BLOCK_ACK_HIST		(3)
#define CW1200_BLOCK_ACK_INTERVAL	(1 * HZ / CW1200_BLOCK_ACK_HIST)
#define CW12XX_ALL_IFS			(-1)

#define IEEE80211_FCTL_WEP      0x4000
#define IEEE80211_QOS_DATAGRP   0x0080

#ifdef MCAST_FWDING
#define WSM_MAX_BUF		30
#endif

/* hidden ssid is only supported when separate probe resp IE
   configuration is supported */
#ifdef PROBE_RESP_EXTRA_IE
#define HIDDEN_SSID	1
#endif

#define CW1200_DRIVER_VERSION "20170210-release"	//michael confirm ? whether need delete

#if 0
enum cw1200_running_status {
    CW1200_RUNNING_STATUS_POWRUP = 0,
    CW1200_RUNNING_STATUS_INITSTART,
    CW1200_RUNNING_STATUS_INITOK,
    CW1200_RUNNING_STATUS_WPA_INITOK,
    CW1200_RUNNING_STATUS_CONNECTTING,
    CW1200_RUNNING_STATUS_CONNECTTED,
    CW1200_RUNNING_STATUS_TCPIPUP,
    CW1200_RUNNING_STATUS_DISCONNEC,
};
#endif

enum cw1200_link_status {
	CW1200_LINK_OFF,
	CW1200_LINK_RESERVE,
	CW1200_LINK_SOFT,
	CW1200_LINK_HARD,
#if defined(CONFIG_CW1200_USE_STE_EXTENSIONS)
	CW1200_LINK_RESET,
	CW1200_LINK_RESET_REMAP,
#endif
};

enum cw1200_bss_loss_status {
	CW1200_BSS_LOSS_NONE,
	CW1200_BSS_LOSS_CHECKING,
	CW1200_BSS_LOSS_CONFIRMING,
	CW1200_BSS_LOSS_CONFIRMED,
};
enum cw1200_data_filterid {
	IPV4ADDR_FILTER_ID = 0,
#ifdef IPV6_FILTERING
	IPV6ADDR_FILTER_ID,
#endif /*IPV6_FILTERING*/
#if 0
	IPV6ADDR_FILTER_ID,
	MACADDR_FILTER_ID,
	MULTICASTADDR_FILTER_ID,
	DHCPPACKET_FILTER_ID,
	SSDPPACKET_FILTER_ID,
	ENABLE_DISABLE_ALL_FILTER,
	ARP_FILTER_ID,
#endif
};

#if 0
/* ipV4 host addr info structure */
struct ipv4_addr_info {
	unsigned char filter_mode;
	unsigned char address_mode;
	unsigned char addr[4];
};
#endif


#ifdef IPV6_FILTERING
/* IPV6 host addr info */
struct ipv6_addr_info {
	unsigned char filter_mode;
	unsigned char address_mode;
	unsigned short ipv6[8];
};
#endif /*IPV6_FILTERING*/

typedef void (*sbus_irq_handler) (void *priv);

struct sbus_priv {
	struct spi_device	*func;
	struct cw1200_common	*core;
    sbus_irq_handler	irq_handler;
	void			*irq_priv;
};


struct sbus_ops {
	int (*sbus_memcpy_fromio)(struct sbus_priv *self, unsigned int addr,
					void *dst, int count);
	int (*sbus_memcpy_toio)(struct sbus_priv *self, unsigned int addr,
					const void *src, int count);
	void (*lock)(struct sbus_priv *self);
	void (*unlock)(struct sbus_priv *self);
	int (*irq_subscribe)(struct sbus_priv *self, sbus_irq_handler handler,
				void *priv);
	int (*irq_unsubscribe)(struct sbus_priv *self);
	int (*reset)(struct sbus_priv *self);
	unsigned int (*align_size)(struct sbus_priv *self, unsigned int size);
	int (*power_mgmt)(struct sbus_priv *self, bool suspend);
	int (*set_block_size)(struct sbus_priv *self, unsigned int size);
};



#define P80211_OUI_LEN	3
struct ieee80211_snap_hdr {
        unsigned char    dsap;   /* always 0xAA */
        unsigned char    ssap;   /* always 0xAA */
        unsigned char    ctrl;   /* always 0x03 */
        unsigned char    oui[P80211_OUI_LEN];    /* organizational universal id */
} __packed;



struct cw1200_link_entry {
	unsigned long			timestamp;
	enum cw1200_link_status		status;
#if defined(CONFIG_CW1200_USE_STE_EXTENSIONS)
	enum cw1200_link_status		prev_status;
#endif
	unsigned char				mac[ETH_ALEN];
	unsigned char				buffered[CW1200_MAX_TID];
	//struct sk_buff_head		rx_queue; //tom here
};
struct firmware {
	unsigned int size;
	unsigned char *data;
};


/* extern */// struct cw1200_debug_common;

struct cw1200_common {
//	struct cw1200_debug_common	*debug;
	//struct cw1200_queue		tx_queue[4];
	//struct cw1200_queue_stats	tx_queue_stats;
//	int				tx_burst_idx;
	//struct cw1200_debug_priv	*debug;

	struct ieee80211_hw		*hw;
	struct mac_address		addresses[CW12XX_MAX_VIFS];
		/*Will be a pointer to a list of VIFs - Dynamically allocated */
	struct ieee80211_vif		*vif_list[CW12XX_MAX_VIFS];
	//atomic_t			num_vifs;
        unsigned char			num_vifs;
//	spinlock_t			vif_list_lock;
	u32				if_id_slot;
	//struct device			*pdev;
	//struct workqueue_struct		*workqueue;

	//struct mutex			conf_mutex;

	const struct sbus_ops		*sbus_ops;
	struct sbus_priv		*sbus_priv;

	/* HW/FW type (HIF_...) */
	int				hw_type;
	int				hw_revision;
	int				fw_revision;

	/* firmware/hardware info */
	unsigned int tx_hdr_len;

	/* Radio data */
	int output_power;
	int noise;

	/* calibration, output power limit and rssi<->dBm conversation data */

	/* BBP/MAC state */
	struct firmware		*sdd;
	struct ieee80211_rate		*rates;
	struct ieee80211_rate		*mcs_rates;
	u8 mac_addr[ETH_ALEN];
	/*TODO:COMBO: To be made per VIFF after mac80211 support */
	struct ieee80211_channel	*channel;
//	u8 bssid[ETH_ALEN];
//	struct wsm_edca_params		edca;
//	struct wsm_tx_queue_params	tx_queue_params;
//	struct wsm_association_mode	association_mode;
//	struct wsm_set_bss_params	bss_params;
//	struct cw1200_ht_info		ht_info;
//	struct wsm_set_pm		powersave_mode;
//	struct wsm_set_pm		firmware_ps_mode;
//	int				cqm_rssi_thold;
//	unsigned			cqm_rssi_hyst;
//	unsigned			cqm_tx_failure_thold;
//	unsigned			cqm_tx_failure_count;
//	bool				cqm_use_rssi;
	unsigned		cqm_avg_rssi_rxrate;	//michael confirm ? need to add at vif
//	int				cqm_link_loss_count;
//	int				cqm_beacon_loss_count;
	int				channel_switch_in_progress;
	//wait_queue_head_t		channel_switch_done;
	u8				long_frame_max_tx_count;
	u8				short_frame_max_tx_count;
//	int				mode;
//	bool				enable_beacon;
//	int				beacon_int;
//	unsigned int				ssid_length;
//	unsigned char				ssid[IEEE80211_MAX_SSID_LEN];
//	bool				hidden_ssid;
//	bool				listening;
//	struct wsm_rx_filter		rx_filter;
//	struct wsm_beacon_filter_table	bf_table;
//	struct wsm_beacon_filter_control bf_control;
//	struct wsm_multicast_filter	multicast_filter;
//	struct wsm_broadcast_addr_filter broadcast_filter;
//	bool				has_multicast_subscription;
//	bool				disable_beacon_filter;
	//struct work_struct		update_filtering_work;
	//struct work_struct		set_beacon_wakeup_period_work;
	/* TODO:COMBO: According to Hong aggregation will happen per VIFF.
	* Keeping in common structure for the time being. Will be moved to VIFF
	* after the mechanism is clear */
	u8				ba_tid_mask;
	int				ba_acc;
	int				ba_cnt;
	int				ba_cnt_rx;
	int				ba_acc_rx;
	int				ba_hist;
	//struct timer_list		ba_timer;
	//spinlock_t			ba_lock;
	bool				ba_ena;
	//struct work_struct              ba_work;
	//#ifdef CONFIG_PM
	//struct cw1200_pm_state		pm_state;
	//#endif
//	struct wsm_p2p_ps_modeinfo	p2p_ps_modeinfo;
//	struct wsm_uapsd_info		uapsd_info;
//	bool				setbssparams_done;
	bool				is_BT_Present;
	bool				is_go_thru_go_neg;
	unsigned char				conf_listen_interval;
//	unsigned int				listen_interval;
//	unsigned int				erp_info;

	/* BH */
	unsigned char			bh_rx;
	unsigned char			bh_tx;
	unsigned char			bh_term;
	unsigned char			bh_suspend;
//	struct task_struct		*bh_thread;
	int				bh_error;
	//wait_queue_head_t		bh_wq;
	//wait_queue_head_t		bh_evt_wq;
	int				buf_id_tx;	/* byte */
	int				buf_id_rx;	/* byte */
	int				wsm_rx_seq;	/* byte */
	int				wsm_tx_seq;	/* byte */
	int				hw_bufs_used;
	int				hw_bufs_used_vif[CW12XX_MAX_VIFS];
	struct sk_buff			*skb_cache;
//	bool				powersave_enabled;
	bool				device_can_sleep;
	/* Keep cw1200 awake (WUP = 1) 1 second after each scan to avoid
	 * FW issue with sleeping/waking up. */
	unsigned char   recent_scan;
	//struct delayed_work		clear_recent_scan_work;

	/* WSM */
	struct wsm_caps			wsm_caps;
	//struct mutex			wsm_cmd_mux;
	struct wsm_buf			wsm_cmd_buf;
	struct wsm_cmd			wsm_cmd;
	//wait_queue_head_t		wsm_cmd_wq;
	//wait_queue_head_t		wsm_startup_done;
	struct wsm_cbc			wsm_cbc;
	unsigned char			tx_lock;
	u32				pending_frame_id;

	/* WSM debug */
	int				wsm_enable_wsm_dumps;
	unsigned int				wsm_dump_max_size;
//	int				wsm_enable_wsm_debug;

	/* BH debug */
//	int				bh_enable_bh_debug;


	/* Scan status */
	struct cw1200_scan scan;
	
	/* TX/RX */
	unsigned long		rx_timestamp;

	/* Scan Timestamp */
	unsigned long		scan_timestamp; 

	/* WSM events */
//	spinlock_t		event_queue_lock;
//	struct list_head	event_queue;
//	struct work_struct	event_handler;

	/* TX rate policy cache */
	struct tx_policy_cache tx_policy_cache;
//	struct work_struct tx_policy_upload_work;

	/* cryptographic engine information */

	/* bit field of glowing LEDs */
	u16 softled_state;

	/* statistics */
	struct ieee80211_low_level_stats stats;

	struct cw1200_ht_info		ht_info;
	int				tx_burst_idx;

	struct ieee80211_iface_limit		if_limits1[2];
	struct ieee80211_iface_limit		if_limits2[2];
	struct ieee80211_iface_limit		if_limits3[2];
	struct ieee80211_iface_combination	if_combs[3];

//	struct mutex			wsm_oper_lock;
//	struct delayed_work		rem_chan_timeout;
        unsigned char			remain_on_channel;
	int				roc_if_id;
	u64				roc_cookie;
	//wait_queue_head_t		offchannel_wq;
	u16				offchannel_done;
	u16				prev_channel;
	int       if_id_selected;
	u32				key_map;
	struct wsm_add_key		keys[WSM_KEY_MAX_INDEX + 1];
#ifdef MCAST_FWDING
	struct wsm_buf		wsm_release_buf[WSM_MAX_BUF];
	u8			buf_released;
#endif	
	u8          connected_sta_cnt;
	u16			vif0_throttle;
	u16			vif1_throttle;
};

/* Virtual Interface State. One copy per VIF */
struct 
cw1200_vif {
	unsigned char			enabled;
	//spinlock_t			vif_lock;
	int				if_id;
	/*TODO: Split into Common and VIF parts */
//	struct cw1200_debug_priv	*debug;
	/* BBP/MAC state */
	u8 bssid[ETH_ALEN];
	struct wsm_edca_params		edca;
	struct wsm_tx_queue_params	tx_queue_params;
	struct wsm_association_mode	association_mode;
	struct wsm_set_bss_params	bss_params;
	struct wsm_set_pm		powersave_mode;
	struct wsm_set_pm		firmware_ps_mode;
	int				power_set_true;
	int				user_power_set_true;
	u8				user_pm_mode;
	int				cqm_rssi_thold;
	unsigned			cqm_rssi_hyst;
	unsigned			cqm_tx_failure_thold;
	unsigned			cqm_tx_failure_count;
	bool				cqm_use_rssi;
	int				cqm_link_loss_count;
	int				cqm_beacon_loss_count;
	int				mode;
	bool				enable_beacon;
	int				beacon_int;
	size_t				ssid_length;
	u8				ssid[IEEE80211_MAX_SSID_LEN];
#ifdef HIDDEN_SSID
	bool				hidden_ssid;
#endif
	bool				listening;
	struct wsm_rx_filter		rx_filter;
	struct wsm_beacon_filter_table	bf_table;
	struct wsm_beacon_filter_control bf_control;
	struct wsm_multicast_filter	multicast_filter;
	bool				has_multicast_subscription;
	struct wsm_broadcast_addr_filter	broadcast_filter;
	bool				disable_beacon_filter;
	struct wsm_arp_ipv4_filter      filter4;
#ifdef IPV6_FILTERING
	struct wsm_ndp_ipv6_filter 	filter6;
#endif /*IPV6_FILTERING*/
//	struct work_struct		update_filtering_work;
//	struct work_struct		set_beacon_wakeup_period_work;
//	#ifdef CONFIG_PM
//	struct cw1200_pm_state_vif	pm_state_vif;
//	#endif
	/*TODO: Add support in mac80211 for psmode info per VIF */
	struct wsm_p2p_ps_modeinfo	p2p_ps_modeinfo;
	struct wsm_uapsd_info		uapsd_info;
	bool				setbssparams_done;
	u32				listen_interval;
	u32				erp_info;
	bool				powersave_enabled;

	/* WSM Join */
	enum cw1200_join_status	join_status;
	unsigned char			join_bssid[ETH_ALEN];
//	unsigned int			pending_frame_id;
	//struct work_struct	join_work;
	//struct delayed_work	join_timeout;
	//struct work_struct	unjoin_work;
	//struct work_struct	offchannel_work;
	int			join_dtim_period;
	bool			delayed_unjoin;

	/* TX/RX and security */
	s8			wep_default_key_id;
	struct work_struct	wep_key_work;
//	unsigned int			key_map;
//	struct wsm_add_key	keys[WSM_KEY_MAX_INDEX];
	unsigned long		rx_timestamp;
	/* ARP offloading Cipher Type */
	u32						cipherType;
	/* AP powersave */
	u32						link_id_map;
	u32						max_sta_ap_mode;
	u32						link_id_after_dtim;
	u32						link_id_uapsd;
	u32						link_id_max;
	u32						wsm_key_max_idx;
	struct cw1200_link_entry link_id_db[CW1250_MAX_STA_IN_AP_MODE];
	//struct work_struct	link_id_work;
	//struct delayed_work	link_id_gc_work;
	unsigned int			sta_asleep_mask;
	unsigned int			pspoll_mask;
	bool			aid0_bit_set;
	//spinlock_t		ps_state_lock;
	bool			buffered_multicasts;
	bool			tx_multicast;
	//struct work_struct	set_tim_work;
	//struct delayed_work	set_cts_work;
	//struct work_struct	multicast_start_work;
	//struct work_struct	multicast_stop_work;
	//struct timer_list	mcast_timeout;


	/* WSM events and CQM implementation */
	//spinlock_t		event_queue_lock;
	//struct list_head	event_queue;
	//struct work_struct	event_handler;
	//struct delayed_work	bss_loss_work;
	//struct delayed_work	connection_loss_work;
	//struct work_struct	tx_failure_work;
	int			delayed_link_loss;
	//spinlock_t		bss_loss_lock;
	int			bss_loss_status;
	int			bss_loss_confirm_id;

	struct ieee80211_vif	*vif;
	struct cw1200_common	*hw_priv;
	struct ieee80211_hw	*hw;

	/* ROC implementation */
//	struct delayed_work		pending_offchanneltx_work;

	/* TX rate policy cache */
	//struct tx_policy_cache tx_policy_cache;
	//struct work_struct tx_policy_upload_work;

	/* cryptographic engine information */

	/* bit field of glowing LEDs */
//	unsigned short softled_state;
//	struct sk_buff *aggr_skb;

	/* statistics */
	//struct ieee80211_low_level_stats stats;
//	unsigned int en_multitx;
#if defined(CONFIG_CW1200_USE_STE_EXTENSIONS)
	/* Workaround for WFD testcase 6.1.10*/
	//struct work_struct	linkid_reset_work;
	u8						action_frame_sa[ETH_ALEN];
	u8						action_linkid;
#endif
//	struct wsm_arp_ipv4_filter filter;
	bool			htcap;
#ifdef  AP_HT_CAP_UPDATE
        u16                     ht_info;
//        struct work_struct      ht_info_update_work;
#endif
};


struct cw1200_sta_priv {
	int link_id;
	struct cw1200_vif *priv;
};


#define cw1200_for_each_vif(_hw_priv, _priv, _i)			\
for (									\
	_i = 0;								\
	_priv = hw_priv->vif_list[_i] ? 				\
	cw12xx_get_vif_from_ieee80211(hw_priv->vif_list[_i]) : NULL,	\
	_i < CW12XX_MAX_VIFS;						\
	_i++								\
)


static inline struct cw1200_common *cw12xx_vifpriv_to_hwpriv(struct cw1200_vif *priv)
{
	return priv->hw_priv;
}


static inline struct cw1200_vif *cw12xx_get_vif_from_ieee80211(struct ieee80211_vif *vif)
{
	return  (struct cw1200_vif *)vif->drv_priv;
}

static inline struct cw1200_vif *cw12xx_hwpriv_to_vifpriv(struct cw1200_common *hw_priv, int if_id)
{
	struct cw1200_vif *vif;

	if (WARN_ON((-1 == if_id) || (if_id > CW12XX_MAX_VIFS)))
		return NULL;
	/* TODO:COMBO: During scanning frames can be received
	 * on interface ID 3 */
//	spin_lock(&hw_priv->vif_list_lock);
//	if (!hw_priv->vif_list[if_id]) {
//		spin_unlock(&hw_priv->vif_list_lock);
//		return NULL;
//	}

	vif = cw12xx_get_vif_from_ieee80211(hw_priv->vif_list[if_id]);
//	WARN_ON(!vif);
//	if (vif)
//		spin_lock(&vif->vif_lock);
//	spin_unlock(&hw_priv->vif_list_lock);
	return vif;
}

static inline struct cw1200_vif *__cw12xx_hwpriv_to_vifpriv(struct cw1200_common *hw_priv, int if_id)
{
	if(WARN_ON((-1 == if_id) || (if_id > CW12XX_MAX_VIFS)));
	/* TODO:COMBO: During scanning frames can be received
	 * on interface ID 3 */
	if (!hw_priv->vif_list[if_id]) {
		return NULL;
	}

	return cw12xx_get_vif_from_ieee80211(hw_priv->vif_list[if_id]);
}

static inline struct cw1200_vif *cw12xx_get_activevif(struct cw1200_common *hw_priv)
{
	return cw12xx_hwpriv_to_vifpriv(hw_priv, ffs(hw_priv->if_id_slot)-1);
}

static inline  bool is_hardware_cw1250(struct cw1200_common *hw_priv)
{
	return (bool)(hw_priv->hw_revision == CW1200_HW_REV_CUT20);
}

static inline  bool is_hardware_cw1260(struct cw1200_common *hw_priv)
{
	return (bool)(hw_priv->hw_revision == CW1260_HW_REV_CUT10);
}

static inline int cw12xx_get_nr_hw_ifaces(struct cw1200_common *hw_priv)
{
	switch(hw_priv->hw_revision) {
		case CW1200_HW_REV_CUT10:
		case CW1200_HW_REV_CUT11:
		case CW1200_HW_REV_CUT20:
		case CW1200_HW_REV_CUT22:
			return 1;
		case CW1250_HW_REV_CUT10:
			return 3;
		default:
			return 1;
	}
}

#define MAX_ERRNO	4095
#define IS_ERR_VALUE(x)  ((x) >= (unsigned long)-MAX_ERRNO)
inline long  IS_ERR(const void *ptr)
{
	return IS_ERR_VALUE((unsigned long)ptr);
}
typedef struct
{
    unsigned int msgid;
}T_MSG;

#define CW1200_BH_QUEUE_COUNT               (80 * 2)//( 40 )
#define CW1200_BH_QUEUE_BUFF_SIZE           ( sizeof(T_MSG) )

#define CW1200_WORK_QUEUE_COUNT             ( 80 ) //3
#define CW1200_WORK_QUEUE_BUFF_SIZE         ( sizeof(T_MSG) )

#ifdef AIRPLAY
#define CW1200_MAC_WORK_QUEUE_COUNT         ( 3 )
#define CW1200_MAC_WORK_QUEUE_BUFF_SIZE     ( 256 )

#define LUDP_RX_QUEUE_COUNT                 ( 2 )
#define LUDP_RX_QUEUE_BUFF_SIZE             ( 1450 )

#else
#define CW1200_MAC_WORK_QUEUE_COUNT         (80 * 2)   // 5 was 20
#define CW1200_MAC_WORK_QUEUE_BUFF_SIZE     3 * sizeof(T_MSG) //( 256 )

#define LUDP_RX_QUEUE_COUNT                 ( 5 )   // was 10
#define LUDP_RX_QUEUE_BUFF_SIZE             ( 1500 )
#endif

#define AIRPLAY_PLAY_QUEUE_COUNT            ( 1 )
#define AIRPLAY_PLAY_QUEUE_BUFF_SIZE        ( 8 )
//#define CW1200_MACRX_QUEUE_COUNT            ( 3 )
//#define CW1200_MACRX_QUEUE_BUFF_SIZE        ( sizeof(T_MSG) )
struct cw1200_txinfo {
	struct sk_buff *skb;
	unsigned queue;
	struct ieee80211_tx_info *tx_info;
	const struct ieee80211_rate *rate;
	struct ieee80211_hdr *hdr;
	unsigned long hdrlen;
	const u8 *da;
	struct cw1200_sta_priv *sta_priv;
	struct cw1200_txpriv txpriv;
};
extern xQueueHandle xCw1200BhQueue;
extern xQueueHandle xCw1200WorkQueue;

#ifdef  CONFIG_CW1200_USE_SPI
int cw1200_spi_probe( struct spi_device* func );
#endif

#ifdef  CONFIG_CW1200_USE_SDIO
int cw1200_sdio_probe( struct sdio_func *func );
#endif
int cw1200_core_probe(const struct sbus_ops *sbus_ops,
		      struct sbus_priv *sbus,
		      struct cw1200_common **pself);
inline void cw1200_tx_queues_lock(struct cw1200_common *hw_priv)
{
	//int i;
	//for (i = 0; i < 4; ++i)
		//cw1200_queue_lock(&hw_priv->tx_queue[i]);     //michael delete
}

inline void cw1200_tx_queues_unlock(struct cw1200_common *hw_priv)
{
	//int i;
	//for (i = 0; i < 4; ++i)
		//cw1200_queue_unlock(&hw_priv->tx_queue[i]);   //michael delete
}

struct ieee80211_hw *cw1200_init_common(unsigned int priv_data_len);
int cw1200_register_common(struct ieee80211_hw *dev);
void cw1200_workqueue_task( void *arg );
void cw1200_mac_workqueue_task( void *arg );
int ffs(int x);
void mdelay( unsigned int count);


//#define CONFIG_MAC80211_MESH 1 //for vs code
#endif
