/*
 * Device handling thread interface for mac80211 ST-Ericsson CW1200 drivers
 *
 * Copyright (c) 2010, ST-Ericsson
 * Author: Dmitry Tarnyagin <dmitry.tarnyagin@stericsson.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef CW1200_BH_H
#define CW1200_BH_H
#include "cw1200_main.h"
/* extern */ struct cw1200_common;
//tom start
typedef struct
{
    unsigned int BhTransferType;
}BhQueueType;  //tom

#define CW1200_BH_RECV_MSGID                ( 0 )	//tom
#define CW1200_BH_SEND_MSGID                ( 1 )	//tom
#define CW1200_BH_RESEND_MSGID              ( 2 )	//tom

//#define CONFIG_CW1200_NON_POWER_OF_TWO_BLOCKSIZES
#define SDIO_BLOCK_SIZE                     ( 64 )	//tom
void cw1200_bh(void *arg);	//tom
void cw1200_init( void *arg );	//tom
//tom end

int cw1200_register_bh(struct cw1200_common *hw_priv);
void cw1200_unregister_bh(struct cw1200_common *hw_priv);
void cw1200_irq_handler(struct cw1200_common *hw_priv);
void cw1200_bh_wakeup(struct cw1200_common *hw_priv, uint8_t if_id);
int cw1200_bh_suspend(struct cw1200_common *hw_priv);
int cw1200_bh_resume(struct cw1200_common *hw_priv);
/* Must be called from BH thread. */
void cw1200_enable_powersave(struct cw1200_vif *priv,
			     bool enable);
int wsm_release_tx_buffer(struct cw1200_common *hw_priv, int count);
int wsm_release_vif_tx_buffer(struct cw1200_common *hw_priv, int if_id,
				int count);

#endif /* CW1200_BH_H */
