/*******************************************************************************
* Project:      Amped'RF WIFI
* File name:    task_priorities.h
*
* Copyright (c) 2016 Amped'RF Inc., AR Technology  All rights reserved.
*******************************************************************************/
#ifndef TASK_PRIORITES_H
#define TASK_PRIORITES_H
#include "FreeRTOSConfig.h"


/*************************************
*            Priorities              *
**************************************/
#define PRIORITY_HIGHEST            (configMAX_PRIORITIES - 1)
#define PRIORITY_SPI                6
#define PRIORITY_UART               6
#define PRIORITY_AWS                6
//-------------------------------------
#define PRIORITY_IP_SEND            6
#define PRIORITY_CW1200_BH          8
#define PRIORITY_CW1200_WORKQ       8
#define PRIORITY_HOST_APD           4
//-------------------------------------
#define PRIORITY_TCP_RX             7
#define PRIORITY_TCP_SERVER         7
#define PRIORITY_UDP_RX             7
#define PRIORITY_TEST_RX            6
#define PRIORITY_TEST_TX            6
#define PRIORITY_ETHERNET_INPUT     (configMAX_PRIORITIES - 1)
#define PRIORITY_TCPIP              (configMAX_PRIORITIES - 2)
//-------------------------------------
#define PRIORITY_CW1200_INIT        1
#define PRIORITY_CW1200_MAC         8
#define PRIORITY_WPA_SUPPLICANT     4
//-------------------------------------
#define PRIORITY_AIRPLAY_MDNS       5
#define PRIORITY_AIRPLAY_AUDIO      7
#define PRIORITY_AIRPLAY_AUTH       6
//#define PRIORITY_AIRPLAY_PLAY       5
#define PRIORITY_AIRPLAY_ADJ        5
//-------------------------------------
#define PRIORITY_DLNA_MULTICAST     8
#define PRIORITY_DLNA_PLAYMUSIC     5
//-------------------------------------
#define PRIORITY_LOW                3
#define PRIORITY_NORMAL             5
#define PRIORITY_HIGH               7

#endif // TASK_PRIORITES_H
//------------------------------------------------------------------------------
// End of task_priorities.h

