/*******************************************************************************
* Project:      Amped'RF Bluetooth
* File name:    iap_type.h
* Author:       Martin Jiang
* Created:      01/12/2010
* Description:  Settings and definitions unique to iAP
*
* Copyright (c) 2010 Amped'RF Inc. All rights reserved.
*******************************************************************************/
#ifndef IAP_TYPE_H
#define IAP_TYPE_H

#ifdef  IAP_ENABLE_DEBUG
#define IAP_INFO_FLOW_DEBUG
#define IAP_DATA_FLOW_DEBUG
#endif

#ifdef  IAP_WITH_IDPS
#define IAP_AUTO_START_IDPS
#define IAP_WITH_AUTH_2ND_PART
//#define IAP_WITH_IDENTIFYDEVICELINGOES
#endif

#ifdef IAP_WITH_AUTH_2ND_PART
//#define DEBUG_WITH_STORAGE
                            // switch for which set of lingo cmds to be used for sending data
                            // if it is defined, Storage Lingo Cmds to be used
                            // otherwise, General Lingo Cmds to be used
#endif

#define TONY_AUTH_ENABLE


#define VERSION_iOS_4x  1
#define VERSION_iOS_5x  2


typedef void (*iAP_Callback_Func)(void);

#define TRANS_ID_LEN    (g_Trans_ID_Enabling ? (sizeof(tiAPTransID)) : 0)

enum
{
    IAP_GENERAL_LINGO                     = 0x00,

    IAP_MICROPHONE_LINGO,
    IAP_SIMPLEREMOTE_LINGO,
    IAP_DISPLAYREMOTE_LINGO,
    IAP_EXTENDEDINTERFACE_LINGO,
    IAP_ACCESSORYPOWER_LINGO,

    IAP_USBHOSTMODE_LINGO,
    IAP_RFTUNER_LINGO,
    IAP_ACCESSORYEQUALIZER_LINGO,
    IAP_SPORTS_LINGO,
    IAP_DIGITALAUDIO_LINGO,

    // Reserved 0x0B
    IAP_STORAGE_LINGO                   = 0x0C,
    // Reserved 0x0D
    IAP_LOCATION_LINGO                  = 0x0E,
    // Reserved
};

#define IAP_MAX_SIZE_OF_SMALL_PACKET    255 // bytes

typedef struct
{
//    uint8 SyncByte;
    uint8 SOP;
    uint8 LengthOfPayload;
}tiAPCmdSmallPacketHead;

#define IAP_MAX_SIZE_OF_LARGE_PACKET    AT_MAX_HOST_DATA_LENGTH // bytes

typedef struct
{
//    uint8 SyncByte;
    uint8 SOP;
    uint8 LengthOfPayloadMarker;    // should be 0x00
    uint8 LengthOfPayload2ndByte;
    uint8 LengthOfPayload1stByte;
}tiAPCmdLargePacketHead;


typedef struct
{
    uint8 lingo_id;                     // IAP_GENERAL_LINGO for general lingo

    uint8 lingo_command_id;             // IAP_GENERAL_REQUESTIDENTIFY_COMMAND for
                                        // Requestidentify command of general lingo
}tiAPCmdPayloadHead;

typedef uint8 tiAPCmdPayloadData;

typedef uint8 tiAPCmdChecksum;

#define IAP_CMD_PAYLOAD_HEAD_LEN    sizeof(tiAPCmdPayloadHead)


#define IAP_SYNC_BYTE       0xFF
#define IAP_SOP             0x55

// ============================================================================================
// ============================================================================================

#define IAP_NULL_CMD        0xff

enum
{
    IAP_GENERAL_REQUESTIDENTIFY_COMMAND                     = 0x00,

    IAP_GENERAL_IDENTIFY_COMMAND,                           // 0x01
    IAP_GENERAL_ACK_COMMAND,
    IAP_GENERAL_REQUESTREMOTEUIMODE_COMMAND,
    IAP_GENERAL_RETURNREMOTEUIMODE_COMMAND,
    IAP_GENERAL_ENTERREMOTEUIMODE_COMMAND,

    IAP_GENERAL_EXITREMOTEUIMODE_COMMAND,                   // 0x06
    IAP_GENERAL_REQUESTIPODNAME_COMMAND,
    IAP_GENERAL_RETURNIPODNAME_COMMAND,
    IAP_GENERAL_REQUESTIPODSOFTWAREVERSION_COMMAND,
    IAP_GENERAL_RETURNIPODSOFTWAREVERSION_COMMAND,

    IAP_GENERAL_REQUESTIPODSERIALNUM_COMMAND,               // 0x0B
    IAP_GENERAL_RETURNIPODSERIALNUM_COMMAND,
    IAP_GENERAL_REQUESTIPODMODELNUM_COMMAND,
    IAP_GENERAL_RETURNIPODMODELNUM_COMMAND,
    IAP_GENERAL_REQUESTLINGOPROTOCOLVERSION_COMMAND,

    IAP_GENERAL_RETURNLINGOPROTOCOLVERSION_COMMAND,         // 0X10

    // Reserved ID 0x11-0x12
    IAP_GENERAL_REQUESTTRANPORTMAXPAYLOADSIZE_COMMAND,//0x11 lkl 2012.11.22
    IAP_GENERAL_RETURNTRANSPORTMAXPAYLOADSIZE,       //0x12 lkl 2012.11.22
    IAP_GENERAL_IDENTIFYDEVICELINGOES_COMMAND             = 0x13,
    IAP_GENERAL_GETDEVAUTHENTICATIONINFO_COMMAND,
    IAP_GENERAL_RETDEVAUTHENTICATIONINFO_COMMAND,

    IAP_GENERAL_ACKDEVAUTHENTICATIONINFO_COMMAND,           // 0X016
    IAP_GENERAL_GETDEVAUTHENTICATIONSIGNATURE_COMMAND,
    IAP_GENERAL_RETDEVAUTHENTICATIONSIGNATURE_COMMAND,
    IAP_GENERAL_ACKDEVAUTHENTICATIONSTATUS_COMMAND,

    // Reserved ID for future 0x1A-0x22

    IAP_GENERAL_NOTIFYIPODSTATECHANGE_COMMAND             = 0x23,
    IAP_GENERAL_GETIPODOPTIONS_COMMAND,
    IAP_GENERAL_RETIPODOPTIONS_COMMAND,

    // RESERVED ID 0X26
    IAP_GENERAL_GETACCESSORYINFO_COMMAND                  = 0x27,
    IAP_GENERAL_RETACCESSORYINFO_COMMAND,
    IAP_GENERAL_GETIPODPREFERENCES_COMMAND,
    IAP_GENERAL_RETIPODPREFERENCES_COMMAND,
    IAP_GENERAL_SETIPODPREFERENCES_COMMAND,

    IAP_GENERAL_STARTIDPS_COMMAND                         = 0x38,
    IAP_GENERAL_SETFIDTOKENVALUES_COMMAND,
    IAP_GENERAL_RETFIDTOKENVALUEACKS_COMMAND,
    IAP_GENERAL_ENDIDPS_COMMAND,
    IAP_GENERAL_IDPSSTATUS_COMMAND,

    IAP_GENERAL_OPENDATASESSIONFORPROTOCOL_COMMAND        = 0x3F,
    IAP_GENERAL_CLOSEDATASESSION_COMMAND,
    IAP_GENERAL_DEVACK_COMMAND,
    IAP_GENERAL_DEVDATATRANSFER_COMMAND,
    IAP_GENERAL_IPODDATATRANSFER_COMMAND,

    IAP_GENERAL_IPODNOTIFICATION_COMMAND                  = 0x4A,
    IAP_GENERAL_GETIPODOPTIONSFORLINGO_COMMAND            = 0x4B,
    IAP_GENERAL_RETIPODOPTIONSFORLINGO_COMMAND            = 0x4C,//lkl 2012.11.22 
    IAP_GENERAL_REQUESTAPPLICATIONLAUNCH_COMMAND          = 0x64,
    IAP_GENERAL_GETNOWPLAYINGFOCUSAPP_COMMAND             = 0x65,//GetNowPlayingFocusApp
    IAP_GENERAL_RETNOWPLAYINGFOCUSAPP_COMMAND             = 0x66,//RetNowPlayingFocusApp

    // Reserved ID for future after 0x2B
};

enum
{
    IAP_STORAGE_IPODACK_COMMAND                         = 0x00,

    IAP_STORAGE_GETIPODCAPS_COMMAND,
    IAP_STORAGE_RETIPODCAPS_COMMAND,
    IAP_STORAGE_RETIPODFILEHANDLE_COMMAND               = 0x04,

    IAP_STORAGE_WRITEIPODFILEDATA_COMMAND               = 0x07,
    IAP_STORAGE_CLOSEIPODFILE_COMMAND,

    IAP_STORAGE_GETIPODFREESPACE_COMMAND                = 0x10,
    IAP_STORAGE_RETIPODFREESPACE_COMMAND,
    IAP_STORAGE_OPENIPODFEATUREFILE_COMMAND,

    IAP_STORAGE_DEVICEACK_COMMAND                       = 0x80,
    IAP_STORAGE_GETDEVICECAPS_COMMAND,
    IAP_STORAGE_RETDEVICECAPS_COMMAND,
};
// ============================================================
//iap_simple_remote_command
// ============================================================

enum
{
    IAP_SIMPLE_REMOTE_CONTEX_BUTTON_STATUS                 = 0x00, //Command 0x00: ContextButtonStatus
    IAP_SIMPLE_REMOTE_ACK_COMMAND                          = 0x01,
    IAP_SIMPLE_REMOTE_VIDEO_BUTTON_STATUS                  = 0x03, //Command 0x03: VideoButtonStatus
    IAP_SIMPLE_REMOTE_AUDIO_BUTTON_STATUS                  = 0x04, //Command 0x04: AudioButtonStatus
    IAP_SIMPLE_REMOTE_IPOD_OUT_BUTTON_STATUS               = 0x0B, //Command 0x0B: iPodOutButtonStatus
    IAP_SIMPLE_REMOTE_ROTATION_INPUT_STATUS                = 0x0C, //Command 0x0C: RotationInputStatus
    IAP_SIMPLE_REMOTE_ROTATION_BUTTON_STATUS               = 0x0D, //Command 0x0D: RadioButtonStatus
    IAP_SIMPLE_REMOTE_CAMER_BUTTON_STATUS                  = 0x0E, //Command 0x0E: CameraButtonStatus
    IAP_SIMPLE_REMOTE_REGISTER_DESCRIPTOR                  = 0x0F, //Command 0x0F: RegisterDescriptor
    IAP_SIMPLE_REMOTE_HID_REPORT_TO_IPOD                   = 0x10, //Command 0x10: SendHIDReportToiPod
    IAP_SIMPLE_REMOTE_HID_REPORT_TO_ACC                    = 0x11, //Command 0x11: SendHIDReportToAcc
    IAP_SIMPLE_REMOTE_UNREGISTER_DESCRIPTOR                = 0x12, //Command 0x12: UnregisterDescriptor
    IAP_SIMPLE_REMOTE_ACCESSIBILITY_EVENT_COMMAND          = 0x13,
    IAP_SIMPLE_REMOTE_GETACCESSIBILITY_PARAMETER_COMMAND   = 0X14,
    IAP_SIMPLE_REMOTE_RETACCESSIBILITY_PARAMETER           = 0X15, //Command 0x15: RetAccessibilityParameter
    IAP_SIMPLE_REMOTE_SETACCESSIBILITY_PARAMETER_COMMAND   = 0X16,
    IAP_SIMPLE_REMOTE_GET_CURRENT_ITEM_PRO                 = 0X17, //Command 0x17: GetCurrentItemProperty
    IAP_SIMPLE_REMOTE_RET_CURRENT_ITEM_PRO                 = 0X18, //Command 0x18: RetCurrentItemProperty
    IAP_SIMPLE_REMOTE_SET_CONTEXT                          = 0X19, //Command 0x19: SetContext
    IAP_SIMPLE_REMOTE_ACC_PARAMETER_CHANGED                = 0X1A, //Command 0x1A: AccParameterChanged
    IAP_SIMPLE_REMOTE_DEV_ACK                              = 0X81, //Command 0x81: DevACK
};
// ============================================================
//iap_simple_remote_command   ACK Message
// ============================================================
enum
{
    IAP_SIMPLE_REMOTE_ACK_COMMAND_OK          = 0x00, //Command OK
    IAP_SIMPLE_REMOTE_ACK_UNKNOWN_CAREGORY    = 0X01, //Unknown track category (not applicable)
    IAP_SIMPLE_REMOTE_ACK_COMMAND_FAILED      = 0X02, //Command failed (valid command, did not succeed)
    IAP_SIMPLE_REMOTE_ACK_OUT_OF_RESOURCES    = 0x03, //Out of resources (Apple device internal allocation failed)
    IAP_SIMPLE_REMOTE_ACK_BAD_PARAMETER       = 0x04, //Bad parameter (command or input parameters invalid)
    IAP_SIMPLE_REMOTE_ACK_UNKNOWN_TRACK_ID    = 0x05, //Unknown track ID (not applicable)
    IAP_SIMPLE_REMOTE_ACK_COMMAND_PENDING     = 0x06, //Command pending (cmdPendTime parameter returned)
    IAP_SIMPLE_REMOTE_ACK_NOT_AUTHENTICATED   = 0x07, //Not authenticated (not authenticated)
    IAP_SIMPLE_REMOTE_ACK_MISMATCHED_VER      = 0x08, //Mismatched authentication protocol version
    IAP_SIMPLE_REMOTE_ACK_HID_IN_USE          =	0x16, //HID descriptor index already in use
};



// ============================================================================================
// ============================================================================================

#define IAP_GENERAL_REQUESTIDENTIFY_PAYLOAD_LEN         0x02

// ============================================================================================


// Command ACK status codes
enum {
    IAP_GENERAL_ACK_SUCCESS = 0x00,
    IAP_GENERAL_ACK_ERROR_UNKNOWN_DATABASE_CATAGORY,
    IAP_GENERAL_ACK_ERROR_COMMAND_FAILED,
    IAP_GENERAL_ACK_ERROR_APPLE_DEVICE_OUT_OF_RESOURCES,
    IAP_GENERAL_ACK_ERROR_BAD_PARA      = 0x04,
    IAP_GENERAL_ACK_ERROR_UNKNOWN_ID,
    IAP_GENERAL_ACK_ERROR_CODE_PENDING  = 0x06,
    IAP_GENERAL_ACK_ERROR_NOT_AUTHENTICATED,
    IAP_GENERAL_ACK_ERROR_BAD_AUTHENTICATION_VERSION,
    IAP_GENERAL_ACK_ERROR_ACCESSORY_POWER_MODE_REQUEST_FAILED,
    IAP_GENERAL_ACK_ERROR_CERTIFICATE_INVALID,
    IAP_GENERAL_ACK_ERROR_CERTIFICATE_PERMISSIONS_INVALID,
    IAP_GENERAL_ACK_ERROR_FILE_IS_IN_USE,
    IAP_GENERAL_ACK_ERROR_INVALID_FILE_HANDLE,
    IAP_GENERAL_ACK_ERROR_DIRECTORY_NOT_EMPTY,
    IAP_GENERAL_ACK_ERROR_OPERATION_TIMED_OUT,
    IAP_GENERAL_ACK_ERROR_COMMAND_UNAVAILABLE,
    IAP_GENERAL_ACK_ERROR_ACCESSORY_DETECT_NOT_GROUNDED,
    IAP_GENERAL_ACK_ERROR_ACCESSORY_NOT_GROUNDED,
    IAP_GENERAL_ACK_MULTISECTION_DATA_SUCCESS,
    IAP_GENERAL_ACK_ERROR_LINGO_BUSY,
    IAP_GENERAL_ACK_ERROR_MAXIMUM_CONNECTIONS,
    IAP_GENERAL_ACK_RESERVED,
    IAP_GENERAL_ACK_ERROR_DROPPED_DATA,
    IAP_GENERAL_ACK_ERROR_INCOMPATIBLE_VIDEO_SETTINGS,
    IAP_GENERAL_ACK_NUM
};


typedef struct
{
    uint8   acknowledgeed_command_id;
}IAP_GENERAL_ACK_NO_PENDING_DATA;

typedef struct
{
    uint8 acknowledgeed_command_id;
    uint8 Max_Pending_Wait_Time_ms_4th_Byte;
    uint8 Max_Pending_Wait_Time_ms_3rd_Byte;
    uint8 Max_Pending_Wait_Time_ms_2nd_Byte;
    uint8 Max_Pending_Wait_Time_ms_1st_Byte;
}IAP_GENERAL_ACK_PENDING_DATA;

typedef union
{
    IAP_GENERAL_ACK_NO_PENDING_DATA     no_pending_data;
    IAP_GENERAL_ACK_PENDING_DATA        pending_data;
}IAP_GENERAL_ACK_RESULT_DATA;

typedef struct
{
    uint8 result_status;        // IAP_GENERAL_ACK_ERROR_CODE_SUCCESS for success
    IAP_GENERAL_ACK_RESULT_DATA result_data;
}tiAPCmdACKResultData;

// ============================================================================================

#define IAP_GENERAL_REQUESTREMOTEUIMODE_PAYLOAD_LEN     0x02

// ============================================================================================

#define IAP_GENERAL_RETURNREMOTEUIMODE_PAYLOAD_LEN      0x03

// ============================================================================================

#define IAP_GENERAL_ENTERREMOTEUIMODE_PAYLOAD_LEN     0x02

// ============================================================================================

#define IAP_GENERAL_EXITREMOTEUIMODE_PAYLOAD_LEN     0x02

// ============================================================================================

#define IAP_GENERAL_REQUESTIPODNAME_PAYLOAD_LEN     0x02

// ============================================================================================

typedef struct
{
    uint8 major_version_num;
    uint8 minor_version_num;
    uint8 revision_version_num;
}tiAPCmdReturniPodSWVerData;

#define IAP_GENERAL_RETURNIPODSOFTWAREVERSION_PAYLOAD_LEN           0x02

// ============================================================================================

#define IAP_GENERAL_REQUESTLINGOPROTOCOLVERSION_PAYLOAD_LEN         0x03

// ============================================================================================

typedef struct
{
    uint8 module_id_4th_byte;
    uint8 module_id_3rd_byte;
    uint8 module_id_2nd_byte;
    uint8 module_id_1st_byte;
}tiAPCmdReturniPodModelNumData;

// ============================================================================================

typedef struct
{
    uint8 lingo_id;
    uint8 major_protocol_version;
    uint8 minor_protocol_version;
}tiAPCmdReturnLingoProtocolVerData;

#define IAP_GENERAL_RETURNLINGOPROTOCOLVERSION_PAYLOAD_LEN         0x05

// ============================================================================================

typedef struct
{
    uint8 status;
}tiAPCmdAckDevAuthenticationInfo;

#define IAP_GENERAL_ACKDEVAUTHENTICATIONINFO_PAYLOAD_LEN         0x03

// ============================================================================================

typedef struct
{
    uint8 trans_id_2nd_byte;
    uint8 trans_id_1st_byte;
}tiAPCmdStartIDPSData;

#define IAP_GENERAL_STARTIDPS_PAYLOAD_LEN                       0x04

typedef tiAPCmdStartIDPSData tiAPTransID;

typedef struct
{
    uint8 lingo_id;                     // IAP_GENERAL_LINGO for general lingo

    uint8 lingo_command_id;             // IAP_GENERAL_REQUESTIDENTIFY_COMMAND for
                                        // Requestidentify command of general lingo

    tiAPTransID trans_id;
}tiAPCmdPayloadHeadWithTransID;

// ============================================================================================
typedef struct  //lkl 2012.11.23
{
     uint8   payloadsize[2]; 
}tiAPCmdMaxPayloadSize;


typedef struct
{
    uint8           num_fid_token_values;
    uint8           fid_token_values[0];    // first byte of tiAPCmdSetFIDTokenValues_FIDTokenValues
}tiAPCmdSetFIDTokenValuesData;

typedef struct
{
    uint8   length;
    uint8   info_byte_one;
    uint8   info_byte_two;
    uint8   data[0];                // first byte of tiAPCmdSetFIDTokenValues_IdentifyToken_1st_Part
                                    //            or tiAPCmdSetFIDTokenValues_AccCapsToken
                                    //            or tiAPCmdSetFIDTokenValues_AccInfoToken
                                    //            or tiAPCmdSetFIDTokenValues_iPodPreferenceToken
}tiAPCmdSetFIDTokenValues_FIDTokenValues;

typedef struct
{
    uint8   num_lingoes;
    uint8   accessory_lingoes[0];
}tiAPCmdSetFIDTokenValues_IdentifyToken_1st_Part;

typedef struct
{
    uint8   device_options_4th_byte;
    uint8   device_options_3rd_byte;
    uint8   device_options_2nd_byte;
    uint8   device_options_1st_byte;

    uint8   device_id_4th_byte;
    uint8   device_id_3rd_byte;
    uint8   device_id_2nd_byte;
    uint8   device_id_1st_byte;
}tiAPCmdSetFIDTokenValues_IdentifyToken_2nd_Part;

typedef struct
{

    uint8   acc_caps_bitmask_8th_byte;
    uint8   acc_caps_bitmask_7th_byte;
    uint8   acc_caps_bitmask_6th_byte;
    uint8   acc_caps_bitmask_5th_byte;
    uint8   acc_caps_bitmask_4th_byte;
    uint8   acc_caps_bitmask_3rd_byte;
    uint8   acc_caps_bitmask_2nd_byte;
    uint8   acc_caps_bitmask_1st_byte;
}tiAPCmdSetFIDTokenValues_AccCapsToken;

typedef struct
{
    uint8   acc_info_type;
    uint8   acc_info[0];
}tiAPCmdSetFIDTokenValues_AccInfoToken;

typedef struct
{
    uint8   protocol_index;
    uint8   protocol_string[0];
}tiAPCmdSetFIDTokenValues_SDKProtocolToken;

typedef struct
{
    uint8   ipod_pref_class;
    uint8   pref_class_setting;
    uint8   restore_on_exit;        // must be 1
}tiAPCmdSetFIDTokenValues_iPodPreferenceToken;

// ============================================================================================

typedef tiAPCmdSetFIDTokenValuesData tiAPCmdRetFIDTokenValueACKsData;

typedef struct
{
    uint8   length;
    uint8   info_byte_one;
    uint8   info_byte_two;
    uint8   ACKStatus;
}tiAPCmdRetFIDTokenValueACKs_IdentifyToken_FIDTokenValueACKs;

typedef struct
{
	tiAPCmdRetFIDTokenValueACKs_IdentifyToken_FIDTokenValueACKs	head;
	uint8	acc_info_type;
}tiAPCmdRetFIDTokenValueACKs_AccInfoToken_FIDTokenValueACKs;

typedef struct
{
    tiAPCmdRetFIDTokenValueACKs_IdentifyToken_FIDTokenValueACKs head;
    uint8   protocolIndex;
}tiAPCmdRetFIDTokenValueACKs_SDKProtocolToken_FIDTokenValueACKs;

// ============================================================================================

typedef struct
{
	uint8		acc_endidps_status;
}tiAPCmdEndIDPSData;

#define IAP_GENERAL_ENDIDPS_PAYLOAD_LEN                       0x05

// ============================================================================================

typedef struct
{
	uint8		status;
}tiAPCmdIDPSStatusData;

#define IAP_GENERAL_IDPSSTATUS_PAYLOAD_LEN                       0x05

// ============================================================================================

typedef struct
{
    uint8       lingo_id;
}tiAPCmdGetiPodOptionsForLingoData;

// ============================================================================================

typedef struct
{
    uint8   device_lingoes_spoken_4th_byte;
    uint8   device_lingoes_spoken_3rd_byte;
    uint8   device_lingoes_spoken_2nd_byte;
    uint8   device_lingoes_spoken_1st_byte;

    uint8   device_options_4th_byte;
    uint8   device_options_3rd_byte;
    uint8   device_options_2nd_byte;
    uint8   device_options_1st_byte;

    uint8   device_id_4th_byte;
    uint8   device_id_3rd_byte;
    uint8   device_id_2nd_byte;
    uint8   device_id_1st_byte;
}tiAPCmdIdentifyDeviceLingoes;

typedef struct
{
    uint8   acc_info_type;
    uint8   data[0];
}tiAPCmdRetAccessoryInfo;

typedef struct
{
    uint8   acc_cap_4th_byte;
    uint8   acc_cap_3rd_byte;
    uint8   acc_cap_2nd_byte;
    uint8   acc_cap_1st_byte;
}tiAPCmdRetAccessoryInfo_AccInfoCap;

typedef tiAPCmdReturniPodSWVerData tiAPCmdRetAccessoryInfo_AccHWVer;
typedef tiAPCmdReturniPodSWVerData tiAPCmdRetAccessoryInfo_AccFWVer;


// ============================================================================================

typedef struct
{
    uint8       session_id_2nd_byte;
    uint8       session_id_1st_byte;
}IAP_SESSION_ID;

typedef struct
{
    IAP_SESSION_ID  session_id;
    uint8           protocol_index;
}tiAPCmdOpenDataSessionForProtocolData;

typedef struct
{
    IAP_SESSION_ID session_id;
    uint8          data[0];
}tiAPCmdiPodDataTransfer;

typedef struct
{
    uint8 ack_status;
    uint8 cmd_id;
}tiAPCmdDevACK;

// ============================================================================================







// ============================================================================================

#define IAP_STORAGE_GETIPODCAPS_PAYLOAD_LEN         0x02

// ============================================================================================

typedef struct
{
    uint8       feature_type;
}tiAPCmdOpeniPodFeatureFileData;

// ============================================================================================

typedef struct
{
    uint8       handle;
}tiAPCmdRetiPodFileHandleData;

// ============================================================================================

typedef struct
{
    uint8       offset_4th_byte;
    uint8       offset_3rd_byte;
    uint8       offset_2nd_byte;
    uint8       offset_1st_byte;
    uint8       handle;
    uint8       data[0];
}tiAPCmdWriteiPodFileDataData;

// ============================================================================================

typedef struct
{
    uint8       command_result_status;
    uint8       command_id;
    uint8       handle;
}tiAPCmdiPodACKData;

// ============================================================================================

typedef tiAPCmdRetiPodFileHandleData tiAPCmdCloseiPodFileData;

// ============================================================================================


//----------------------------------------------------------------------------
//  iap simple remote lingo
//----------------------------------------------------------------------------

typedef struct
{
    uint8 paramType;
    uint8 paramValue;
}tiAPCmdRetAccessibilityPara;

#endif // IAP_TYPE_H
//------------------------------------------------------------------------------

